/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.task.timing.lite.runner;

import com.dangdang.ddframe.job.lite.lifecycle.domain.JobSettings;
import com.dangdang.ddframe.job.reg.base.CoordinatorRegistryCenter;
import com.google.gson.Gson;
import com.ohaotian.task.timing.lite.service.JobSettingsService;
import java.text.MessageFormat;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.cache.TreeCache;
import org.apache.curator.framework.recipes.cache.TreeCacheEvent;
import org.apache.curator.framework.recipes.cache.TreeCacheListener;
import org.apache.curator.utils.ZKPaths;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.stereotype.Component;

@Component
public class LiteCommandLineRunner
implements CommandLineRunner {
    private static final Logger log = LogManager.getLogger(LiteCommandLineRunner.class);
    private static final String STORAGE_PARENT_PATH = "/%_Metadata_Storage_%";
    @Autowired
    private CoordinatorRegistryCenter registryCenter;
    @Autowired
    private JobSettingsService jobSettingsService;

    public void run(String ... strings) throws Exception {
        this.registryCenter.addCacheData(STORAGE_PARENT_PATH);
        TreeCache treeCache = (TreeCache)this.registryCenter.getRawCache(STORAGE_PARENT_PATH);
        treeCache.getListenable().addListener((Object)new TreeCacheListener(){
            private Gson gson = new Gson();

            public void childEvent(CuratorFramework curatorFramework, TreeCacheEvent event) throws Exception {
                switch (event.getType()) {
                    case NODE_ADDED: {
                        String path = event.getData().getPath();
                        if (LiteCommandLineRunner.STORAGE_PARENT_PATH.equals(path)) break;
                        String jobName = ZKPaths.getNodeFromPath((String)path);
                        String jobData = LiteCommandLineRunner.this.registryCenter.get(path);
                        log.info(() -> MessageFormat.format("Add Job,JobName:{0},JobData:{1}", jobName, jobData));
                        JobSettings jobSettings = (JobSettings)this.gson.fromJson(jobData, JobSettings.class);
                        LiteCommandLineRunner.this.jobSettingsService.initNewJob(jobSettings);
                        break;
                    }
                }
            }
        });
    }
}

