/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.task.timing.lite.watcher;

import com.ohaotian.task.timing.lite.config.RegistryCenterProperties;
import com.ohaotian.task.timing.lite.service.UpdateShardingItemExecLogService;
import java.util.Optional;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.cache.PathChildrenCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class LiteOfflineWatcher {
    private static final Logger log = LoggerFactory.getLogger(LiteOfflineWatcher.class);
    @Autowired
    private CuratorFramework zkClient;
    @Autowired
    private RegistryCenterProperties registryCenterProperties;
    @Autowired
    private UpdateShardingItemExecLogService updateShardingItemExecLogService;

    @Bean
    public PathChildrenCache initLiteOfflineWatcher() throws Exception {
        String instancesPath = this.registryCenterProperties.getInstances();
        PathChildrenCache childrenCache = new PathChildrenCache(this.zkClient, instancesPath, true);
        childrenCache.start(PathChildrenCache.StartMode.POST_INITIALIZED_EVENT);
        childrenCache.getListenable().addListener((client, event) -> {
            switch (event.getType()) {
                case CHILD_ADDED: {
                    break;
                }
                case CHILD_REMOVED: {
                    String path = event.getData().getPath();
                    log.info(">>>>>>>>>>>>>>> Lite has gone offline, Path: {}", (Object)event.getData().getPath());
                    Optional.ofNullable(path).map(s -> path.split("/")[4].split("@-@")[0]).ifPresent(ip -> this.updateShardingItemExecLogService.updateShardingItemExecLog((String)ip));
                    break;
                }
                case CHILD_UPDATED: {
                    break;
                }
            }
        });
        return childrenCache;
    }
}

