/*==============================================================*/
/* Table: business_define                                       */
/*==============================================================*/
create table if not exists business_define
(
   business_id          bigint(32) not null auto_increment comment '任务唯一标识',
   service_id           bigint(20) comment '服务ID',
   service_name         varchar(128) comment '服务名',
   service_type         tinyint(2) comment '服务类型',
   business_name        varchar(1024) not null comment '任务名称',
   business_desc        varchar(2048) comment '任务描述',
   business_type        varchar(2) not null comment '1：定时任务 2：批量任务（延时）',
   create_date          datetime not null comment '任务创建时间',
   last_data            datetime comment '最后修改时间',
   split_rule           varchar(1024) comment '作业分片规则',
   split_total          int(4) comment '作业分片总数',
   business_para        varchar(1024) comment '作业参数',
   cron_expression      varchar(128) comment 'cron表达式',
   data_scope_type      varchar(2) comment '1：条件 2：集合 3：文件',
   data_rule            varchar(1024) comment '当微服务类型为多条时配置如何分组',
   split_num            varchar(10) comment '批量任务微服务可一次处理多笔时配置',
   business_status      tinyint(2) not null comment '0：失效 ;1：有效',
   appointment_time     datetime comment '预约时间',
   user_group_id        bigint(20) comment '用户组编号',
   staff_no             varchar(100) comment '工号',
   is_retry             tinyint(2) comment '是否重试 0：否 1：是',
   timeout              int(6) comment '超时时间，单位毫秒',
   retry_count          int(6) comment '重试次数',
   alarm_type           varchar(50) comment '告警类型',
   phone_number         varchar(500) comment '手机号，多个手机号以英文逗号隔开',
   contacts             varchar(1000) comment '联系人，多个联系人以英文逗号隔开',
   primary key (business_id)
);

alter table business_define comment '定时任务定义表';


/*==============================================================*/
/* Table: c_alarm_log                                           */
/*==============================================================*/
create table if not exists c_alarm_log
(
   id                   bigint(20) not null auto_increment comment 'id',
   business_id          bigint(32) not null comment '任务唯一标识',
   alarm_content        varchar(4000) comment '告警内容',
   data                 varchar(1000) comment '返回数据',
   rsp_desc             varchar(100) comment '返回描述',
   is_success           int(11) comment '是否成功 0：失败，1：成功',
   create_time          datetime not null comment '创建时间',
   primary key (id)
);

alter table c_alarm_log comment '告警日志表';


/*==============================================================*/
/* Table: c_hsf_service_conf                                    */
/*==============================================================*/
create table if not exists c_hsf_service_conf
(
   conf_id              bigint(20) not null auto_increment comment '配置ID',
   service_id           bigint(20) not null comment '服务id',
   group_name           varchar(128) comment '组名',
   service_name         varchar(128) not null comment '接口名称',
   method_name          varchar(128) not null comment '方法名称',
   version_no           varchar(128) comment '版本号',
   time_out             int comment '超时时间(毫秒)',
   param_type           varchar(200) comment '参数类型，接口入参BO',
   user_group_id        bigint(20) comment '用户组编号',
   staff_no             varchar(100) comment '工号',
   create_time          datetime comment '创建时间',
   modified_time        datetime comment '更新时间',
   status               tinyint(2) not null default 0 comment ' 0：失效 1：生效',
   primary key (conf_id)
)
ENGINE = InnoDB
DEFAULT CHARACTER SET = utf8;

alter table c_hsf_service_conf comment 'hsf服务属性配置表';


/*==============================================================*/
/* Table: c_http_service_config                                 */
/*==============================================================*/
create table if not exists c_http_service_config
(
   conf_id              bigint(20) not null auto_increment comment '配置ID',
   service_id           bigint(20) not null comment '服务id',
   service_address      varchar(512) comment '服务地址',
   request_type         tinyint(2) comment '请求方式 1：get 2：post 3：put 4：delete 5：options 6：head 7：trace 8：connect',
   req_code_format      varchar(2048) comment '请求格式定义',
   rsp_code_format      varchar(2048) comment '返回格式定义',
   user_group_id        bigint(20) comment '用户组编号',
   staff_no             varchar(100) comment '工号',
   create_time          datetime comment '创建时间',
   modified_time        datetime comment '更新时间',
   status               tinyint(2) not null default 0 comment ' 0：失效 1：生效',
   primary key (conf_id)
)
ENGINE = InnoDB
DEFAULT CHARACTER SET = utf8;

alter table c_http_service_config comment 'http/https服务配置表';


/*==============================================================*/
/* Table: c_mq_service_conf                                     */
/*==============================================================*/
create table if not exists c_mq_service_conf
(
   conf_id              bigint(20) not null auto_increment comment '配置ID',
   service_id           bigint(20) not null comment '服务id',
   mq_address           varchar(512) comment 'mq地址',
   mqTopic              varchar(512) not null comment 'topic',
   mq_tag               varchar(512) not null comment '方法名称',
   object_class         varchar(512) comment '对象类',
   mq_pid               varchar(512) comment 'pid',
   access_key           varchar(200) comment '鉴权用AccessKey',
   secret_key           varchar(200) comment '鉴权用SecretKey',
   user_group_id        bigint(20) comment '用户组编号',
   staff_no             varchar(100) comment '工号',
   create_time          datetime comment '创建时间',
   modified_time        datetime comment '更新时间',
   status               tinyint(2) not null default 0 comment ' 0：失效 1：生效',
   primary key (conf_id)
)
ENGINE = InnoDB
DEFAULT CHARACTER SET = utf8;

alter table c_mq_service_conf comment 'mq属性配置表';


/*==============================================================*/
/* Table: c_python_service_conf                                 */
/*==============================================================*/
create table if not exists c_python_service_conf
(
   conf_id              bigint not null auto_increment comment '配置ID',
   service_id           bigint comment '服务ID',
   class_name           varchar(1024) comment '类名  1:get 2:post',
   python_objname       varchar(1024) comment '对象名',
   python_address       varchar(1024) comment '路径',
   python_host          varchar(32) comment '远程脚本主机',
   python_port          int comment '远程脚本主机端口',
   python_user_name     varchar(20) comment '用户名',
   python_password      varchar(32) comment '密码',
   python_encoding      varchar(20) comment '编码',
   python_version       varchar(8) comment '版本',
   user_group_id        bigint(20) comment '用户组编号',
   staff_no             varchar(100) comment '工号',
   create_time          datetime comment '创建时间',
   modified_time        datetime comment '更新时间',
   status               tinyint(2) not null default 0 comment ' 0：失效 1：生效',
   primary key (conf_id)
);

alter table c_python_service_conf comment 'Python服务配置表';


/*==============================================================*/
/* Table: c_service_define                                      */
/*==============================================================*/
create table if not exists c_service_define
(
   service_id           bigint(20) not null auto_increment comment '服务id',
   service_name         varchar(128) comment '服务名称',
   service_desc         varchar(512) comment '服务描述',
   service_type         tinyint(2) not null comment '服务类型 1：http/https 2：dubbo 3：hsf 4：python2/3  5：shell  6：mq',
   user_group_id        bigint(20) comment '用户组编号',
   staff_no             varchar(100) comment '工号',
   create_time          datetime comment '创建时间',
   modified_time        datetime comment '更新时间',
   status               tinyint(2) not null default 0 comment ' 0：失效 1：生效',
   primary key (service_id)
)
ENGINE = InnoDB
DEFAULT CHARACTER SET = utf8;

alter table c_service_define comment '服务定义表';


/*==============================================================*/
/* Table: c_shell_service_conf                                  */
/*==============================================================*/
create table if not exists c_shell_service_conf
(
   conf_id              bigint not null auto_increment comment '配置ID',
   d_s_service_id       bigint(20) comment '服务id',
   service_id           bigint comment '服务ID',
   shell_address        varchar(1024) comment '脚本路径',
   shell_host           varchar(32) comment '脚本主机IP',
   shell_port           int comment '脚本主机端口',
   shell_user_name      varchar(20) comment '主机用户名',
   shell_password       varchar(32) comment '主机密码',
   shell_encoding       varchar(32) comment '脚本编码',
   user_group_id        bigint(20) comment '用户组编号',
   staff_no             varchar(100) comment '工号',
   create_time          datetime comment '创建时间',
   modified_time        datetime comment '更新时间',
   status               tinyint(2) not null default 0 comment ' 0：失效 1：生效',
   remark               varchar(20) comment '备注',
   primary key (conf_id)
);

alter table c_shell_service_conf comment 'SHELL服务配置表';


/*==============================================================*/
/* Table: JOB_EXECUTION_LOG                                     */
/*==============================================================*/
create table if not exists JOB_EXECUTION_LOG
(
   id                   varchar(40) not null comment 'id',
   job_name             varchar(100) comment 'job名称',
   task_id              varchar(255) comment '任务id',
   hostname             varchar(255) not null comment 'host名称',
   ip                   varchar(50) comment 'ip',
   sharding_item        int(11) comment '分片',
   execution_source     varchar(20) comment '执行源',
   failure_cause        varchar(4000) comment '失败原因',
   is_success           int(11) not null comment '是否成功',
   start_time           datetime comment '开始时间',
   complete_time        datetime comment '完成时间',
   alarm_status         tinyint(2) comment '告警状态',
   primary key (id)
)
ENGINE = InnoDB
DEFAULT CHARACTER SET = utf8;

alter table JOB_EXECUTION_LOG comment 'job执行日志表';


/*==============================================================*/
/* Table: JOB_STATUS_TRACE_LOG                                  */
/*==============================================================*/
create table if not exists JOB_STATUS_TRACE_LOG
(
   id                   varchar(40) not null comment 'id',
   job_name             varchar(100) comment 'job名称',
   original_task_id     varchar(255) comment '原始任务id',
   task_id              varchar(255) comment '任务id',
   slave_id             varchar(50) comment '随从id',
   source               varchar(50) comment '分片',
   execution_type       varchar(20) comment '执行类型',
   sharding_item        varchar(100) comment '分片',
   state                varchar(20) comment '状态',
   message              varchar(4000) comment '信息',
   creation_time        datetime comment '创建时间',
   primary key (id)
)
ENGINE = InnoDB
DEFAULT CHARACTER SET = utf8;

alter table JOB_STATUS_TRACE_LOG comment 'job状态跟踪日志表';


/*==============================================================*/
/* Table: rt_batch_task                                         */
/*==============================================================*/
create table if not exists rt_batch_task
(
   batch_task_id        varchar(20) not null comment '任务批次表id(日期+序列，序列以1开头)',
   service_id           bigint(20) not null comment '服务id',
   task_def_id          varchar(100) comment '任务定义id',
   task_total           bigint(20) comment '任务总数',
   task_success_total   bigint(20) comment '成功数',
   task_fail_total      bigint(20) comment '失败数',
   task_status          tinyint(2) comment '任务状态： 0：未处理 1：处理中 2:：部分成功 3：全部成功 4：全部失败',
   file_name            varchar(100) comment '文件名称',
   file_address         varchar(200) comment '文件地址',
   data_scope_type      varchar(2) comment '1：集合 2：文件',
   province_code        varchar(2) comment '省份编码',
   area_code            varchar(6) comment '地市编码',
   county_code          varchar(10) comment '区县编码',
   chnl_code            varchar(7) comment '渠道编码',
   oper_staff_no        varchar(100) comment '操作工号',
   oper_depart_code     varchar(7) comment '操作部门',
   busi_data_json       longtext comment '源、目标数据JSON',
   create_time          datetime comment '创建时间',
   modified_time        datetime comment '更新时间',
   batch_task_req_no    varchar(50) not null comment '批量任务流水号',
   task_input_type      tinyint(2) comment '任务输入类型（1：文件  2：条件）',
   task_exec_order      tinyint(4) comment '任务执行顺序',
   output_file_name     varchar(100) comment '输出文件名',
   output_file_address  varchar(100) comment '输出文件路径',
   output_file_format   tinyint(2) comment '输出文件格式（1：txt，2：excel）',
   has_column_name      tinyint(2) comment '是否包含列名（0：不含 1：包含）',
   column_names         varchar(2048) comment '列名名称（名称以逗号隔开）',
   user_group_id        bigint(20) comment '用户组编号',
   primary key (batch_task_id)
);

alter table rt_batch_task comment '实时任务任务批次表';


/*==============================================================*/
/* Table: rt_consumer_exception                                 */
/*==============================================================*/
create table if not exists rt_consumer_exception
(
   consumer_exc_id      bigint(20) not null auto_increment comment '消费异常id',
   task_message_id      bigint(20) not null comment '任务消息表id',
   batch_task_id        varchar(20) not null comment '任务批次表id(日期+序列，序列以1开头)',
   task_def_id          varchar(100) not null comment '任务定义id',
   message_body         text comment '消息体',
   exception_desc       varchar(1024) comment '异常描述',
   call_exception_count tinyint(2) comment '调用异常次数',
   next_call_timestamp  bigint(20) comment '下次调用业务系统时间戳',
   modified_time        datetime comment '更新时间',
   create_time          datetime comment '创建时间',
   primary key (consumer_exc_id)
);

alter table rt_consumer_exception comment '实时任务消费异常表';


/*==============================================================*/
/* Table: rt_file_body_define                                   */
/*==============================================================*/
create table if not exists rt_file_body_define
(
   file_body_id         bigint(20) not null auto_increment comment '文件体定义ID',
   file_def_id          bigint(20) comment '文件定义ID',
   column_id            int(6) comment '列序',
   columns_code         varchar(255) comment '字段英文名',
   columns_type         varchar(50) comment '1:纯数字 2.文本',
   is_must              tinyint comment '0：否 1：是',
   columns_name         varchar(255) comment '字段中文名称',
   user_group_id        bigint(20) comment '用户组编号',
   staff_no             varchar(100) comment '工号',
   create_time          datetime comment '创建时间',
   modified_time        datetime comment '更新时间',
   status               tinyint(2) not null default 0 comment ' 0：失效 1：生效',
   remark               varchar(255) comment '备注',
   primary key (file_body_id)
);

alter table rt_file_body_define comment '实时任务文件体格式定义表';


/*==============================================================*/
/* Table: rt_file_export_log                                    */
/*==============================================================*/
create table if not exists rt_file_export_log
(
   id                   bigint not null auto_increment comment '日志ID',
   file_name            varchar(255) comment '文件名称',
   file_address         varchar(255) comment '文件地址',
   batch_task_id        bigint(20) comment '任务批次表id',
   export_time          datetime comment '导出时间',
   export_type          int comment '1明细导出 2任务导出',
   status               int comment '0导出中 1已完成',
   province_code        varchar(2) comment '省份编码',
   area_code            varchar(6) comment '地市编码',
   county_code          varchar(10) comment '区县编码',
   chnl_code            varchar(7) comment '渠道编码',
   oper_staff_no        varchar(100) comment '操作工号',
   oper_depart_code     varchar(7) comment '操作部门',
   create_time          datetime comment '创建时间',
   modified_time        datetime comment '更新时间',
   task_def_id          bigint(20) NOT NULL COMMENT '任务定义id',
   primary key (id)
);

alter table rt_file_export_log comment '实时任务文件导出日志表';


/*==============================================================*/
/* Table: rt_file_rule                                          */
/*==============================================================*/
create table if not exists rt_file_rule
(
   file_def_id          bigint(20) not null auto_increment comment '文件定义ID',
   task_def_id          varchar(100) not null comment '任务定义id',
   file_name            varchar(100) comment '文件名',
   file_type            varchar(50) comment '文件类型 1:txt 2:excel 3:csv',
   file_body            text comment '文件体',
   user_group_id        bigint(20) comment '用户组编号',
   staff_no             varchar(100) comment '工号',
   create_time          datetime comment '创建时间',
   modified_time        datetime comment '更新时间',
   status               tinyint(2) not null default 0 comment ' 0：失效 1：生效',
   primary key (file_def_id)
);

alter table rt_file_rule comment '实时任务文件定义规则表';


/*==============================================================*/
/* Table: rt_producer_exception                                 */
/*==============================================================*/
create table if not exists rt_producer_exception
(
   producer_exc_id      bigint(20) not null auto_increment comment '发送异常id',
   task_message_id      bigint(20) comment '任务消息表id',
   batch_task_id        varchar(20) not null comment '任务批次表id(日期+序列，序列以1开头)',
   task_def_id          varchar(100) not null comment '任务定义id',
   message_body         text comment '消息体',
   exception_desc       varchar(1024) comment '异常描述',
   push_exception_count tinyint(20) comment '发送异常次数',
   next_push_timestamp  bigint(20) comment '下次发送时间戳',
   modified_time        datetime comment '更新时间',
   create_time          datetime comment '创建时间',
   primary key (producer_exc_id)
);

alter table rt_producer_exception comment '实时任务发送异常表';


/*==============================================================*/
/* Table: rt_task_define                                        */
/*==============================================================*/
create table if not exists rt_task_define
(
   id                   bigint(20) not null auto_increment comment '主键id',
   task_def_id          varchar(100) not null comment '任务定义id',
   service_id           bigint(20) not null comment '服务id',
   service_type         tinyint(2) not null comment '服务类型 1：http/https 2：dubbo 3：hsf 4：python2/3  5：shell ',
   conf_id              bigint(20) comment 'topic配置id',
   task_name            varchar(1024) comment '任务名称',
   task_desc            varchar(2048) comment '任务描述',
   task_priority        tinyint(4) default 0 comment '任务优先级 0：低 1：中 2：高',
   task_split_field     varchar(128) comment '任务拆分字段',
   task_split_rule      tinyint(2) comment '任务拆分规则 1：默认单条 2：轮询取模 ',
   task_split_max_size  int(6) comment '任务明细最大数量',
   task_split_value     varchar(20) comment '分组参数：分组时的取模基数',
   user_group_id        bigint(20) comment '用户组编号',
   staff_no             varchar(100) comment '工号',
   create_time          datetime comment '创建时间',
   modified_time        datetime comment '更新时间',
   status               tinyint(2) not null default 0 comment ' 0：失效 1：生效',
   task_output_type     tinyint(2) comment '任务输出类型（1：文件 2：其他 ）',
   task_input_type      tinyint(2) comment '任务输入类型（1：文件  2：条件）',
   sharding_total       int(4) comment '分片数(仅用于输入类型为条件时使用)',
   primary key (id)
)
ENGINE = InnoDB
DEFAULT CHARACTER SET = utf8;

alter table rt_task_define comment '实时任务任务定义表';


/*==============================================================*/
/* Table: rt_task_detail                                        */
/*==============================================================*/
create table if not exists rt_task_detail
(
   task_detail_id       bigint(20) not null auto_increment comment '任务明细id',
   partition_key        bigint(20) not null comment '分库键(值为任务消息id)',
   task_message_id      bigint(20) comment '任务消息表id',
   batch_task_id        varchar(20) not null comment '任务批次表id',
   task_detail          text comment '任务明细数据',
   task_detail_status   tinyint(2) comment '任务明细状态 0：未处理1：处理中 2：处理成功 3：处理失败',
   order_number         varchar(20) comment '订单号',
   device_number        varchar(11) comment '手机号码',
   iccid                VARCHAR (20) comment '卡号',
   province_code        varchar(2) comment '省份编码',
   area_code            varchar(6) comment '地市编码',
   county_code          varchar(10) comment '区县编码',
   chnl_code            varchar(7) comment '渠道编码',
   oper_staff_no        varchar(100) comment '操作工号',
   oper_depart_code     varchar(7) comment '操作部门',
   create_time          datetime comment '创建时间',
   modified_time        datetime comment '更新时间',
   batch_task_req_no    varchar(50) not null comment '批量任务流水号',
   ext_json             VARCHAR (50) comment '扩展json，如存放分片项',
   business_return_json varchar(1024) comment '业务返回数据',
   fail_reason          varchar(160) comment '失败原因',
   primary key (task_detail_id),
   KEY `inx_batch_task_id` (`batch_task_id`),
   KEY `idx_create_time` (`create_time`),
   KEY `auto_shard_key_partition_key` (`partition_key`)
)
ENGINE = InnoDB
DEFAULT CHARACTER SET = utf8;

alter table rt_task_detail comment '实时任务任务明细表（分库表）';


/*==============================================================*/
/* Table: rt_task_message                                       */
/*==============================================================*/
create table if not exists rt_task_message
(
   task_message_id      bigint(20) not null auto_increment comment '任务消息表id',
   batch_task_id        varchar(20) comment '任务批次表id(日期+序列，序列以1开头)',
   partition_key        bigint(20) not null comment '分库键(值为任务消息id)',
   message_body         blob comment '消息体',
   message_detail_total bigint(20) comment '消息明细总数',
   message_success_total bigint(20) comment '成功数',
   message_fail_total   bigint(20) comment '失败数',
   task_message_status  tinyint(2) comment '任务消息状态： 0：未处理 1：已发送 2：处理中 3:：部分成功 4：全部成功 5：全部失败',
   province_code        varchar(2) comment '省份编码',
   area_code            varchar(6) comment '地市编码',
   county_code          varchar(10) comment '区县编码',
   chnl_code            varchar(7) comment '渠道编码',
   oper_staff_no        varchar(100) comment '操作工号',
   oper_depart_code     varchar(7) comment '操作部门',
   create_time          datetime comment '创建时间',
   modified_time        datetime comment '更新时间',
   batch_task_req_no    varchar(50) not null comment '批量任务流水号',
   ext_json             VARCHAR (50) comment '扩展json，如存放分片项',
   primary key (task_message_id),
   KEY `auto_shard_key_partition_key` (`partition_key`)
);

alter table rt_task_message comment '实时任务任务消息表（分库表）';


/*==============================================================*/
/* Table: rt_topic_conf                                         */
/*==============================================================*/
create table if not exists rt_topic_conf
(
   conf_id              bigint(20) not null auto_increment comment 'topic配置id',
   topic_name           varchar(50) comment 'topic名称',
   topic_desc           varchar(100) comment 'topic描述',
   pid                  varchar(50) comment '提供者pid',
   cid                  varchar(50) comment '消费者cid',
   tag                  varchar(50) comment 'tag名称，默认*',
   user_group_id        bigint(20) comment '用户组编号',
   staff_no             varchar(100) comment '工号',
   create_time          datetime comment '创建时间',
   modified_time        datetime comment '更新时间',
   status               tinyint(2) not null default 0 comment ' 0：失效 1：生效',
   primary key (conf_id)
);

alter table rt_topic_conf comment '实时任务Topic配置表';


/*==============================================================*/
/* Table: sharding_item_exec_log                                */
/*==============================================================*/
create table if not exists sharding_item_exec_log
(
   id                   bigint(20) not null auto_increment comment 'id',
   job_exec_log_id      varchar(40) not null comment 'job执行日志表id',
   job_name             varchar(100) comment 'job名称',
   trigger_ip           varchar(50) comment '需触发ip',
   exec_ip              varchar(50) comment '实际执行ip',
   sharding_item        int(6) comment '分片',
   status               tinyint(2) not null comment '状态 0：失败，1：成功，2：执行中',
   start_time           datetime not null comment '开始时间',
   complete_time        datetime comment '完成时间',
   primary key (id)
);

alter table sharding_item_exec_log comment '分片触发日志表';