/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.task.timing.lite.jobs;

import com.alibaba.fastjson.JSONObject;
import com.aliyun.openservices.ons.api.Message;
import com.aliyun.openservices.ons.api.ONSFactory;
import com.aliyun.openservices.ons.api.Producer;
import com.aliyun.openservices.ons.api.SendResult;
import com.dangdang.ddframe.job.api.ShardingContext;
import com.dangdang.ddframe.job.api.simple.SimpleJob;
import com.ohaotian.task.timing.lite.utils.SerializeUtils;
import java.text.MessageFormat;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;

@Service
@Scope(value="prototype")
public class MQTimedTaskJob
implements SimpleJob {
    private static final Logger log = LogManager.getLogger(MQTimedTaskJob.class);

    public void execute(ShardingContext shardingContext) {
        Properties properties = new Properties();
        String jobName = shardingContext.getJobName();
        String taskId = shardingContext.getTaskId();
        int shardingTotalCount = shardingContext.getShardingTotalCount();
        int shardingItem = shardingContext.getShardingItem();
        String shardingParameter = StringUtils.isBlank((CharSequence)shardingContext.getShardingParameter()) ? "" : shardingContext.getShardingParameter();
        String jobParameter = shardingContext.getJobParameter();
        if (log.isInfoEnabled()) {
            log.info("============================================================================================");
            log.info(() -> MessageFormat.format("\u7ebf\u7a0b\u540d\u79f0:{0}", Thread.currentThread().getName()));
            log.info(() -> MessageFormat.format("Job\u7c7b\u540d:{0}", this.getClass().getCanonicalName()));
            log.info(() -> MessageFormat.format("\u4f5c\u4e1a\u540d\u79f0:{0}", jobName));
            log.info(() -> MessageFormat.format("\u4f5c\u4e1a\u4efb\u52a1ID:{0}", taskId));
            log.info(() -> MessageFormat.format("\u5206\u7247\u603b\u6570:{0}", shardingTotalCount));
            log.info(() -> MessageFormat.format("\u5206\u914d\u4e8e\u672c\u4f5c\u4e1a\u5b9e\u4f8b\u7684\u5206\u7247\u9879:{0}", shardingItem));
            log.info(() -> MessageFormat.format("\u5206\u914d\u4e8e\u672c\u4f5c\u4e1a\u5b9e\u4f8b\u7684\u5206\u7247\u53c2\u6570:{0}", shardingParameter));
            log.info(() -> MessageFormat.format("\u4f5c\u4e1a\u81ea\u5b9a\u4e49\u53c2\u6570:{0}", jobParameter));
        }
        JSONObject jsonObject = JSONObject.parseObject((String)jobParameter);
        JSONObject mqParam = jsonObject.getJSONObject("MQ_PARAM");
        String mqAddress = jsonObject.getString("MQ_ADDRESS");
        String mqTag = jsonObject.getString("MQ_TAG");
        String mqTopic = jsonObject.getString("MQ_TOPIC");
        String accessKey = jsonObject.getString("ACCESS_KEY");
        String secretKey = jsonObject.getString("SECRET_KEY");
        String mqObjectClass = jsonObject.getString("MQ_OBJECT_CLASS");
        Long businessId = jsonObject.getLong("BUSINESS_ID");
        mqParam.put("SHARDING_ITEM", (Object)shardingItem);
        mqParam.put("SHARDING_PARAMETER", (Object)shardingParameter);
        mqParam.put("JOB_NAME", (Object)jobName);
        mqParam.put("JOB_TASK_ID", (Object)taskId);
        mqParam.put("SHARDING_TOTAL_COUNT", (Object)shardingTotalCount);
        mqParam.put("BUSINESS_ID", (Object)businessId);
        Producer producer = null;
        try {
            properties.put("AccessKey", accessKey);
            properties.put("SecretKey", secretKey);
            properties.put("NAMESRV_ADDR", mqAddress);
            producer = ONSFactory.createProducer((Properties)properties);
            producer.start();
            Message msg = new Message(mqTopic, mqTag, SerializeUtils.serialize(mqParam));
            msg.setKey("ORDERID_100");
            SendResult sendResult = producer.send(msg);
            System.out.println("Send Message success. Message ID is: " + sendResult.getMessageId());
            producer.shutdown();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage());
        }
        finally {
            if (producer != null) {
                producer.shutdown();
            }
        }
        log.info("------------------------------------MQ\u5b9a\u65f6\u4efb\u52a1--------------------------------------------------------");
    }
}

