/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.task.timing.lite.service.impl;

import com.dangdang.ddframe.job.api.ElasticJob;
import com.dangdang.ddframe.job.api.JobType;
import com.dangdang.ddframe.job.config.JobCoreConfiguration;
import com.dangdang.ddframe.job.config.JobTypeConfiguration;
import com.dangdang.ddframe.job.config.dataflow.DataflowJobConfiguration;
import com.dangdang.ddframe.job.config.script.ScriptJobConfiguration;
import com.dangdang.ddframe.job.config.simple.SimpleJobConfiguration;
import com.dangdang.ddframe.job.event.JobEventConfiguration;
import com.dangdang.ddframe.job.event.rdb.JobEventRdbConfiguration;
import com.dangdang.ddframe.job.lite.api.listener.ElasticJobListener;
import com.dangdang.ddframe.job.lite.config.LiteJobConfiguration;
import com.dangdang.ddframe.job.lite.lifecycle.domain.JobSettings;
import com.dangdang.ddframe.job.lite.spring.api.SpringJobScheduler;
import com.dangdang.ddframe.job.reg.base.CoordinatorRegistryCenter;
import com.ohaotian.task.timing.lite.constant.Consts;
import com.ohaotian.task.timing.lite.service.JobSettingsService;
import javax.sql.DataSource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Service;

@Service
public class JobSettingsServiceImpl
implements JobSettingsService,
ApplicationContextAware {
    private static final Logger log = LogManager.getLogger(JobSettingsServiceImpl.class);
    @Autowired
    private CoordinatorRegistryCenter registryCenter;
    @Autowired
    private DataSource dataSource;
    private ApplicationContext applicationContext;

    @Override
    public void initNewJob(JobSettings jobSettings) {
        log.traceEntry("initNewJob(JobSettings)", new Object[]{jobSettings});
        JobCoreConfiguration.Builder jobCoreConfigurationBuilder = JobCoreConfiguration.newBuilder((String)jobSettings.getJobName(), (String)jobSettings.getCron(), (int)jobSettings.getShardingTotalCount()).shardingItemParameters(jobSettings.getShardingItemParameters()).jobParameter(jobSettings.getJobParameter()).description(jobSettings.getDescription()).failover(jobSettings.isFailover()).misfire(jobSettings.isMisfire());
        JobCoreConfiguration jobCoreConfiguration = jobCoreConfigurationBuilder.build();
        SimpleJobConfiguration jobTypeConfiguration = null;
        if (JobType.SIMPLE.name().equals(jobSettings.getJobType())) {
            jobTypeConfiguration = new SimpleJobConfiguration(jobCoreConfiguration, jobSettings.getJobClass());
        } else if (JobType.SCRIPT.name().equals(jobSettings.getJobType())) {
            jobTypeConfiguration = new ScriptJobConfiguration(jobCoreConfiguration, jobSettings.getScriptCommandLine());
        } else if (JobType.DATAFLOW.name().equals(jobSettings.getJobType())) {
            jobTypeConfiguration = new DataflowJobConfiguration(jobCoreConfiguration, jobSettings.getJobClass(), jobSettings.isStreamingProcess());
        }
        LiteJobConfiguration liteJobConfiguration = LiteJobConfiguration.newBuilder((JobTypeConfiguration)jobTypeConfiguration).monitorExecution(jobSettings.isMonitorExecution()).maxTimeDiffSeconds(jobSettings.getMaxTimeDiffSeconds()).monitorPort(jobSettings.getMonitorPort()).jobShardingStrategyClass(jobSettings.getJobShardingStrategyClass()).reconcileIntervalMinutes(jobSettings.getReconcileIntervalMinutes()).overwrite(true).build();
        ElasticJob elasticJob = null;
        try {
            elasticJob = (ElasticJob)this.applicationContext.getBean(Class.forName(jobSettings.getJobClass()));
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        if (this.isTimedTask(jobSettings.getJobClass())) {
            new SpringJobScheduler(elasticJob, this.registryCenter, liteJobConfiguration, (JobEventConfiguration)new JobEventRdbConfiguration(this.dataSource), new ElasticJobListener[0]).init();
        } else {
            new SpringJobScheduler(elasticJob, this.registryCenter, liteJobConfiguration, new ElasticJobListener[0]).init();
        }
    }

    private boolean isTimedTask(String jobClass) {
        return Consts.TIMED_TASKS.contains(jobClass);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

