/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.task.timing.lite.watcher;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.dangdang.ddframe.job.api.ShardingContext;
import com.dangdang.ddframe.job.executor.ShardingContexts;
import com.dangdang.ddframe.job.util.env.IpUtils;
import com.ohaotian.task.timing.business.enums.ShardingTriggerStatusEnum;
import com.ohaotian.task.timing.business.service.bo.ShardingTriggerBO;
import com.ohaotian.task.timing.lite.config.LiteRegistryCenterProperties;
import com.ohaotian.task.timing.lite.domain.mapper.JobExecutionLogDAO;
import com.ohaotian.task.timing.lite.domain.mapper.ShardingItemExecLogDAO;
import com.ohaotian.task.timing.lite.domain.po.JobExecutionLogPO;
import com.ohaotian.task.timing.lite.domain.po.ShardingItemExecLogPO;
import com.ohaotian.task.timing.lite.utils.DistributedLockUtil;
import java.lang.reflect.Method;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.cache.PathChildrenCache;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ShardingTriggerNodeWatcher {
    private static final Logger log = LoggerFactory.getLogger(ShardingTriggerNodeWatcher.class);
    @Autowired
    private CuratorFramework zkClient;
    @Autowired
    private LiteRegistryCenterProperties registryCenterProperties;
    @Autowired
    private DistributedLockUtil distributedLockUtil;
    @Autowired
    private ShardingItemExecLogDAO shardingItemExecLogDAO;
    @Autowired
    private JobExecutionLogDAO jobExecutionLogDAO;
    private static String currentIp = IpUtils.getIp();
    private static String lockKey = "";

    @Bean
    public PathChildrenCache initShardingTriggerNodeWatcher() throws Exception {
        PathChildrenCache childrenCache = new PathChildrenCache(this.zkClient, this.registryCenterProperties.getShardingTriggerNode(), true);
        childrenCache.start(PathChildrenCache.StartMode.POST_INITIALIZED_EVENT);
        childrenCache.getListenable().addListener((client, event) -> {
            switch (event.getType()) {
                case CHILD_ADDED: {
                    log.info("CHILD_ADDED: {}, DATA: {}", (Object)event.getData().getPath(), (Object)new String(event.getData().getData()));
                    this.triggerShardingItem(event);
                    break;
                }
                case CHILD_REMOVED: {
                    log.info("CHILD_REMOVED: {}", (Object)event.getData().getPath());
                    break;
                }
                case CHILD_UPDATED: {
                    log.info("CHILD_UPDATED: {}, DATA: {}", (Object)event.getData().getPath(), (Object)new String(event.getData().getData()));
                    break;
                }
            }
        });
        return childrenCache;
    }

    private void triggerShardingItem(PathChildrenCacheEvent event) {
        try {
            ShardingTriggerBO shardingTriggerBO = (ShardingTriggerBO)JSONObject.parseObject((byte[])event.getData().getData(), ShardingTriggerBO.class, (Feature[])new Feature[0]);
            String waitTriggerIp = shardingTriggerBO.getIp();
            if (waitTriggerIp.equals(currentIp)) {
                this.doTrigger(shardingTriggerBO);
            } else {
                ShardingItemExecLogPO shardingItemExecLog;
                List instances = (List)this.zkClient.getChildren().forPath(this.registryCenterProperties.getInstances());
                ArrayList<String> ips = new ArrayList<String>();
                if (instances != null && instances.size() > 0) {
                    for (String instance : instances) {
                        String ip = instance.split("@-@")[0];
                        ips.add(ip);
                    }
                }
                if (!ips.contains(waitTriggerIp) && this.distributedLockUtil.lock(lockKey = shardingTriggerBO.getJobName() + "@-@" + shardingTriggerBO.getShardingItem()) && (shardingItemExecLog = this.shardingItemExecLogDAO.selectByPrimaryKey(shardingTriggerBO.getId())).getStatus().equals(ShardingTriggerStatusEnum.IN_EXEC.getCode())) {
                    this.doTrigger(shardingTriggerBO);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTrigger(ShardingTriggerBO shardingTriggerBO) {
        try {
            ShardingItemExecLogPO shardingItemExecLog = new ShardingItemExecLogPO();
            shardingItemExecLog.setExecIp(currentIp);
            shardingItemExecLog.setId(shardingTriggerBO.getId());
            this.shardingItemExecLogDAO.updateByPrimaryKeySelective(shardingItemExecLog);
            byte[] bytes = (byte[])this.zkClient.getData().forPath(this.registryCenterProperties.getMetadata() + "/" + shardingTriggerBO.getJobName());
            if (bytes != null && bytes.length > 0) {
                String[] shardingItemParametersArr;
                JSONObject jsonObject = JSONObject.parseObject((String)new String(bytes));
                String jobClass = jsonObject.getString("jobClass");
                String jobParameter = jsonObject.getString("jobParameter");
                String shardingItemParameters = jsonObject.getString("shardingItemParameters");
                int shardingTotalCount = jsonObject.getIntValue("shardingTotalCount");
                HashMap<Integer, String> shardingItemParameterMap = new HashMap<Integer, String>();
                if (shardingItemParameters != null && (shardingItemParametersArr = shardingItemParameters.split(",")) != null && shardingItemParametersArr.length > 0) {
                    for (int i = 0; i < shardingItemParametersArr.length; ++i) {
                        String[] shardingItemParameterArr = shardingItemParametersArr[i].split("=");
                        shardingItemParameterMap.put(Integer.valueOf(shardingItemParameterArr[0]), shardingItemParameterArr[1]);
                    }
                }
                ShardingContexts shardingContexts = new ShardingContexts("", shardingTriggerBO.getJobName(), shardingTotalCount, jobParameter, shardingItemParameterMap, 0);
                ShardingContext shardingContext = new ShardingContext(shardingContexts, shardingTriggerBO.getShardingItem().intValue());
                Class<?> clazz = Class.forName(jobClass);
                Method method = clazz.getDeclaredMethod("execute", ShardingContext.class);
                method.invoke(clazz.newInstance(), shardingContext);
                ShardingItemExecLogPO shardingItemExecLog1 = new ShardingItemExecLogPO();
                shardingItemExecLog1.setCompleteTime(LocalDateTime.now());
                shardingItemExecLog1.setId(shardingTriggerBO.getId());
                shardingItemExecLog1.setStatus(ShardingTriggerStatusEnum.SUCCESS.getCode());
                this.shardingItemExecLogDAO.updateByPrimaryKeySelective(shardingItemExecLog1);
                JobExecutionLogPO jobExecutionLogPO = new JobExecutionLogPO();
                jobExecutionLogPO.setId(shardingTriggerBO.getJobExecLogId());
                jobExecutionLogPO.setIsSuccess(1);
                jobExecutionLogPO.setFailureCause("");
                jobExecutionLogPO.setCompleteTime(LocalDateTime.now().toString());
                this.jobExecutionLogDAO.updateByPrimaryKeySelective(jobExecutionLogPO);
            }
        }
        catch (Exception e) {
            log.error("=========================\uff1a\u5206\u7247\u89e6\u53d1\u6267\u884c\u5931\u8d25");
            e.printStackTrace();
            ShardingItemExecLogPO shardingItemExecLog = new ShardingItemExecLogPO();
            shardingItemExecLog.setCompleteTime(LocalDateTime.now());
            shardingItemExecLog.setId(shardingTriggerBO.getId());
            shardingItemExecLog.setStatus(ShardingTriggerStatusEnum.FAIL.getCode());
            this.shardingItemExecLogDAO.updateByPrimaryKeySelective(shardingItemExecLog);
            JobExecutionLogPO jobExecutionLogPO = new JobExecutionLogPO();
            jobExecutionLogPO.setId(shardingTriggerBO.getJobExecLogId());
            jobExecutionLogPO.setCompleteTime(LocalDateTime.now().toString());
            this.jobExecutionLogDAO.updateByPrimaryKeySelective(jobExecutionLogPO);
        }
        finally {
            String path = this.registryCenterProperties.getShardingTriggerNode() + "/" + shardingTriggerBO.getJobName() + "@-@" + shardingTriggerBO.getShardingItem();
            try {
                this.zkClient.delete().forPath(path);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.distributedLockUtil.unlock(lockKey);
        }
    }
}

