/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.task.timing.lite.jobs;

import com.alibaba.dubbo.config.ApplicationConfig;
import com.alibaba.dubbo.config.ReferenceConfig;
import com.alibaba.dubbo.config.RegistryConfig;
import com.alibaba.dubbo.rpc.service.GenericService;
import com.alibaba.fastjson.JSONObject;
import com.dangdang.ddframe.job.api.ShardingContext;
import com.dangdang.ddframe.job.api.simple.SimpleJob;
import java.text.MessageFormat;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;

@Service
@Scope(value="prototype")
public class DubboTimedTaskJob
implements SimpleJob {
    private static final Logger log = LogManager.getLogger(DubboTimedTaskJob.class);

    private GenericService builDubboDynamicService(String applicationName, String zkAddress, String groupName, String interfaceName, String version, Integer timeout) {
        ApplicationConfig application = new ApplicationConfig();
        application.setName(applicationName);
        RegistryConfig registry = new RegistryConfig();
        registry.setAddress(zkAddress);
        ReferenceConfig reference = new ReferenceConfig();
        reference.setInterface(interfaceName);
        if (StringUtils.isNotBlank((CharSequence)groupName)) {
            reference.setGroup(groupName);
        }
        if (StringUtils.isNotBlank((CharSequence)version)) {
            reference.setVersion(version);
        }
        if (timeout != null) {
            reference.setTimeout(timeout);
        }
        reference.setApplication(application);
        reference.setRegistry(registry);
        reference.setGeneric(Boolean.valueOf(true));
        return (GenericService)reference.get();
    }

    public void execute(ShardingContext shardingContext) {
        String jobName = shardingContext.getJobName();
        String taskId = shardingContext.getTaskId();
        int shardingTotalCount = shardingContext.getShardingTotalCount();
        int shardingItem = shardingContext.getShardingItem();
        String shardingParameter = StringUtils.isBlank((CharSequence)shardingContext.getShardingParameter()) ? "" : shardingContext.getShardingParameter();
        String jobParameter = shardingContext.getJobParameter();
        if (log.isInfoEnabled()) {
            log.info("============================================================================================");
            log.info(() -> MessageFormat.format("\u7ebf\u7a0b\u540d\u79f0:{0}", Thread.currentThread().getName()));
            log.info(() -> MessageFormat.format("Job\u7c7b\u540d:{0}", this.getClass().getCanonicalName()));
            log.info(() -> MessageFormat.format("\u4f5c\u4e1a\u540d\u79f0:{0}", jobName));
            log.info(() -> MessageFormat.format("\u4f5c\u4e1a\u4efb\u52a1ID:{0}", taskId));
            log.info(() -> MessageFormat.format("\u5206\u7247\u603b\u6570:{0}", shardingTotalCount));
            log.info(() -> MessageFormat.format("\u5206\u914d\u4e8e\u672c\u4f5c\u4e1a\u5b9e\u4f8b\u7684\u5206\u7247\u9879:{0}", shardingItem));
            log.info(() -> MessageFormat.format("\u5206\u914d\u4e8e\u672c\u4f5c\u4e1a\u5b9e\u4f8b\u7684\u5206\u7247\u53c2\u6570:{0}", shardingParameter));
            log.info(() -> MessageFormat.format("\u4f5c\u4e1a\u81ea\u5b9a\u4e49\u53c2\u6570:{0}", jobParameter));
        }
        JSONObject jsonObject = JSONObject.parseObject((String)jobParameter);
        JSONObject dubboParam = jsonObject.getJSONObject("DUBBO_PARAM");
        String dubboParamType = jsonObject.getString("DUBBO_PARAM_TYPE");
        Integer dubboTimeOut = jsonObject.getInteger("DUBBO_TIME_OUT");
        String dubboGroup = jsonObject.getString("DUBBO_GROUP");
        String dubboServiceName = jsonObject.getString("DUBBO_SERVICE_NAME");
        String dubboMethod = jsonObject.getString("DUBBO_METHOD");
        String dubboVersion = jsonObject.getString("DUBBO_VERSION");
        String dubboZkAddress = jsonObject.getString("DUBBO_ZK_ADDRESS");
        String dubboApplicationName = jsonObject.getString("DUBBO_APPLICATION_NAME");
        Long businessId = jsonObject.getLong("BUSINESS_ID");
        dubboParam.put("SHARDING_ITEM", (Object)shardingItem);
        dubboParam.put("SHARDING_PARAMETER", (Object)shardingParameter);
        dubboParam.put("JOB_NAME", (Object)jobName);
        dubboParam.put("JOB_TASK_ID", (Object)taskId);
        dubboParam.put("SHARDING_TOTAL_COUNT", (Object)shardingTotalCount);
        dubboParam.put("BUSINESS_ID", (Object)businessId);
        try {
            GenericService genericService = this.builDubboDynamicService(dubboApplicationName, dubboZkAddress, dubboGroup, dubboServiceName, dubboVersion, dubboTimeOut);
            genericService.$invoke(dubboMethod, new String[]{dubboParamType}, new Object[]{dubboParam});
        }
        catch (Exception ex) {
            log.error(() -> MessageFormat.format("\u5b9a\u65f6\u4efb\u52a1:{0}.\u6267\u884c\u5f02\u5e38:{1}", this.getClass().getCanonicalName(), ex));
            throw new RuntimeException(ex.getMessage());
        }
        log.info("--------------------------------------------------------------------------------------------");
    }
}

