/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.task.timing.lite.jobs;

import com.alibaba.fastjson.JSONObject;
import com.dangdang.ddframe.job.api.ShardingContext;
import com.dangdang.ddframe.job.api.simple.SimpleJob;
import com.ohaotian.task.timing.business.service.UpdateBathJobDetailService;
import com.ohaotian.task.timing.business.service.bo.BatchJobDetailReqBO;
import com.ohaotian.task.timing.lite.utils.HttpUtils;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.function.BiFunction;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;

@Service
@Scope(value="prototype")
public class HttpRealTimeTaskJob
implements SimpleJob {
    private static final Logger log = LogManager.getLogger(HttpRealTimeTaskJob.class);
    private static final String SUCCESS_CODE = "0000";
    @Autowired
    private UpdateBathJobDetailService updateBathJobDetailService;

    public void execute(ShardingContext shardingContext) {
        String jobName = shardingContext.getJobName();
        String taskId = shardingContext.getTaskId();
        int shardingTotalCount = shardingContext.getShardingTotalCount();
        int shardingItem = shardingContext.getShardingItem();
        String shardingParameter = StringUtils.isBlank((CharSequence)shardingContext.getShardingParameter()) ? "" : shardingContext.getShardingParameter();
        String jobParameter = shardingContext.getJobParameter();
        if (log.isInfoEnabled()) {
            log.info("============================================================================================");
            log.info(() -> MessageFormat.format("\u7ebf\u7a0b\u540d\u79f0:{0}", Thread.currentThread().getName()));
            log.info(() -> MessageFormat.format("Job\u7c7b\u540d:{0}", this.getClass().getCanonicalName()));
            log.info(() -> MessageFormat.format("\u4f5c\u4e1a\u540d\u79f0:{0}", jobName));
            log.info(() -> MessageFormat.format("\u4f5c\u4e1a\u4efb\u52a1ID:{0}", taskId));
            log.info(() -> MessageFormat.format("\u5206\u7247\u603b\u6570:{0}", shardingTotalCount));
            log.info(() -> MessageFormat.format("\u5206\u914d\u4e8e\u672c\u4f5c\u4e1a\u5b9e\u4f8b\u7684\u5206\u7247\u9879:{0}", shardingItem));
            log.info(() -> MessageFormat.format("\u5206\u914d\u4e8e\u672c\u4f5c\u4e1a\u5b9e\u4f8b\u7684\u5206\u7247\u53c2\u6570:{0}", shardingParameter));
            log.info(() -> MessageFormat.format("\u4f5c\u4e1a\u81ea\u5b9a\u4e49\u53c2\u6570:{0}", jobParameter));
        }
        JSONObject jsonJobParamJson = JSONObject.parseObject((String)jobParameter);
        String url = jsonJobParamJson.getString("HTTP_SERVER_ADDRESS");
        String method = jsonJobParamJson.getString("HTTP_METHOD");
        String shardingParameterReal = shardingParameter.replaceAll("#", ",");
        JSONObject jsonShardingParameter = JSONObject.parseObject((String)shardingParameterReal);
        int groupCount = jsonShardingParameter.getInteger("GROUP_COUNT");
        String busiDataJson = jsonShardingParameter.getString("BUSI_DATA_JSON");
        String batchNo = jsonShardingParameter.getString("BATCH_NO");
        BiFunction<Integer, String, String> biFunction = (status, response) -> {
            if (status.intValue() == HttpStatus.OK.value()) {
                return response;
            }
            return response;
        };
        try {
            if ("2".equals(method)) {
                log.debug("\u8bf7\u6c42\u4e1a\u52a1\u53c2\u6570\u4e3a:" + busiDataJson);
                String result = HttpUtils.doPostJson(url, busiDataJson, biFunction);
                log.debug("\u4e1a\u52a1\u8fd4\u56de\u7ed3\u679c\u4e3a:" + result);
                if (groupCount == 0) {
                    BatchJobDetailReqBO bo = new BatchJobDetailReqBO();
                    String taskDetailId = jsonShardingParameter.getString("TASK_DETAIL_ID");
                    bo.setRspBody(result);
                    bo.setBatchNo(batchNo);
                    bo.setTaskDetailId(Long.valueOf(taskDetailId));
                    bo.setCallStatus(HttpStatus.OK.value() + "");
                    this.updateBathJobDetailService.updateBatchJobDetail(bo);
                    this.updateBathJobDetailService.updateRedisAndStore(batchNo);
                } else {
                    BatchJobDetailReqBO batchBo = new BatchJobDetailReqBO();
                    batchBo.setRspBody(result);
                    batchBo.setBatchNo(batchNo);
                    batchBo.setCallStatus(HttpStatus.OK.value() + "");
                    this.updateBathJobDetailService.updateBatchJobDetail(batchBo);
                    this.updateBathJobDetailService.updateRedisAndStore(batchNo);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

