/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.task.timing.lite.jobs;

import com.alibaba.fastjson.JSONObject;
import com.dangdang.ddframe.job.api.ShardingContext;
import com.dangdang.ddframe.job.api.simple.SimpleJob;
import com.ohaotian.task.timing.lite.utils.HttpUtils;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Objects;
import java.util.function.BiFunction;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.context.annotation.Scope;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;

@Service
@Scope(value="prototype")
public abstract class HttpTimedTaskJob
implements SimpleJob {
    private static final Logger log = LogManager.getLogger(HttpTimedTaskJob.class);
    private static final String SUCCESS_CODE = "0000";

    public void execute(ShardingContext shardingContext) {
        String jobName = shardingContext.getJobName();
        String taskId = shardingContext.getTaskId();
        int shardingTotalCount = shardingContext.getShardingTotalCount();
        int shardingItem = shardingContext.getShardingItem();
        String shardingParameter = StringUtils.isBlank((CharSequence)shardingContext.getShardingParameter()) ? "" : shardingContext.getShardingParameter();
        String jobParameter = shardingContext.getJobParameter();
        JSONObject jsonObject = JSONObject.parseObject((String)jobParameter);
        JSONObject httpParam = jsonObject.getJSONObject("HTTP_PARAM");
        String httpServerAddress = jsonObject.getString("HTTP_SERVER_ADDRESS");
        String httpMethod = jsonObject.getString("HTTP_METHOD");
        String businessId = jsonObject.getString("BUSINESS_ID");
        Integer isRetry = jsonObject.getInteger("IS_RETRY");
        Integer timeout = jsonObject.getInteger("TIMEOUT");
        Integer retryCount = jsonObject.getInteger("RETRY_COUNT");
        if (log.isInfoEnabled()) {
            log.info("============================================================================================");
            log.info(() -> MessageFormat.format("\u7ebf\u7a0b\u540d\u79f0:{0}", Thread.currentThread().getName()));
            log.info(() -> MessageFormat.format("Job\u7c7b\u540d:{0}", this.getClass().getCanonicalName()));
            log.info(() -> MessageFormat.format("\u4f5c\u4e1a\u540d\u79f0:{0}", jobName));
            log.info(() -> MessageFormat.format("\u4f5c\u4e1a\u4efb\u52a1ID:{0}", taskId));
            log.info(() -> MessageFormat.format("\u5206\u7247\u603b\u6570:{0}", shardingTotalCount));
            log.info(() -> MessageFormat.format("\u5206\u914d\u4e8e\u672c\u4f5c\u4e1a\u5b9e\u4f8b\u7684\u5206\u7247\u9879:{0}", shardingItem));
            log.info(() -> MessageFormat.format("\u5206\u914d\u4e8e\u672c\u4f5c\u4e1a\u5b9e\u4f8b\u7684\u5206\u7247\u53c2\u6570:{0}", shardingParameter));
            log.info(() -> MessageFormat.format("\u4f5c\u4e1a\u81ea\u5b9a\u4e49\u53c2\u6570:{0}", jobParameter));
        }
        httpParam.put("SHARDING_ITEM", (Object)shardingItem);
        httpParam.put("SHARDING_PARAMETER", (Object)shardingParameter);
        BiFunction<Integer, String, String> biFunction = (status, response) -> {
            if (status.intValue() == HttpStatus.OK.value()) {
                JSONObject object = JSONObject.parseObject((String)response);
                String respCodeValue = ((JSONObject)object.get((Object)"RSP")).getString("RSP_CODE");
                log.info("http response is :" + object);
                if (SUCCESS_CODE.equals(respCodeValue)) {
                    return "\u6210\u529f";
                }
                return "\u5931\u8d25";
            }
            return "\u8c03\u7528\u5f02\u5e38";
        };
        try {
            String result;
            if ("2".equals(httpMethod) && Objects.equals(result = HttpUtils.doPostJson(httpServerAddress, httpParam.toJSONString(), biFunction, timeout), "\u8c03\u7528\u5f02\u5e38")) {
                this.invokeRetry(httpParam, httpServerAddress, isRetry, timeout, retryCount, biFunction, businessId, shardingItem);
            }
        }
        catch (IOException e) {
            this.invokeRetry(httpParam, httpServerAddress, isRetry, timeout, retryCount, biFunction, businessId, shardingItem);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeRetry(JSONObject httpParam, String httpServerAddress, Integer isRetry, Integer timeout, Integer retryCount, BiFunction<Integer, String, String> biFunction, String businessId, int shardingItem) {
        block9: {
            if (Objects.equals(isRetry, 1) && retryCount != null) {
                Exception exception = null;
                for (int i = 0; i < retryCount; ++i) {
                    block8: {
                        String alarmInfo;
                        try {
                            String retryResult = HttpUtils.doPostJson(httpServerAddress, httpParam.toJSONString(), biFunction, timeout);
                            if (!Objects.equals(retryResult, "\u6210\u529f") && !Objects.equals(retryResult, "\u5931\u8d25")) break block8;
                            if (i != retryCount - 1) break block9;
                            alarmInfo = exception == null ? "Http \u8c03\u7528\u5f02\u5e38" : ExceptionUtils.getStackTrace((Throwable)exception).substring(0, 1500);
                        }
                        catch (Exception ex) {
                            String alarmInfo2;
                            try {
                                exception = ex;
                                log.info("HttpUtils.doPostJson error: ", (Throwable)ex);
                                if (i != retryCount - 1) continue;
                                alarmInfo2 = exception == null ? "Http \u8c03\u7528\u5f02\u5e38" : ExceptionUtils.getStackTrace((Throwable)exception).substring(0, 1500);
                            }
                            catch (Throwable throwable) {
                                if (i == retryCount - 1) {
                                    String alarmInfo3 = exception == null ? "Http \u8c03\u7528\u5f02\u5e38" : ExceptionUtils.getStackTrace((Throwable)exception).substring(0, 1500);
                                    throw new RuntimeException(alarmInfo3);
                                }
                                throw throwable;
                            }
                            throw new RuntimeException(alarmInfo2);
                        }
                        throw new RuntimeException(alarmInfo);
                    }
                    if (i != retryCount - 1) continue;
                    String alarmInfo = exception == null ? "Http \u8c03\u7528\u5f02\u5e38" : ExceptionUtils.getStackTrace((Throwable)exception).substring(0, 1500);
                    throw new RuntimeException(alarmInfo);
                }
            } else {
                throw new RuntimeException("Http \u8c03\u7528\u5f02\u5e38");
            }
        }
    }
}

