/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.task.timing.lite.jobs;

import ch.ethz.ssh2.Connection;
import ch.ethz.ssh2.ServerHostKeyVerifier;
import ch.ethz.ssh2.Session;
import com.alibaba.fastjson.JSONObject;
import com.dangdang.ddframe.job.api.ShardingContext;
import com.dangdang.ddframe.job.api.simple.SimpleJob;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;

@Service
@Scope(value="prototype")
public class PythonTimedTaskJob
implements SimpleJob {
    private static final Logger log = LogManager.getLogger(PythonTimedTaskJob.class);

    public void execute(ShardingContext shardingContext) {
        String jobName = shardingContext.getJobName();
        String taskId = shardingContext.getTaskId();
        int shardingTotalCount = shardingContext.getShardingTotalCount();
        int shardingItem = shardingContext.getShardingItem();
        String shardingParameter = StringUtils.isBlank((CharSequence)shardingContext.getShardingParameter()) ? "" : shardingContext.getShardingParameter();
        String jobParameter = shardingContext.getJobParameter();
        if (log.isInfoEnabled()) {
            log.info("============================================================================================");
            log.info(() -> MessageFormat.format("\u7ebf\u7a0b\u540d\u79f0:{0}", Thread.currentThread().getName()));
            log.info(() -> MessageFormat.format("Job\u7c7b\u540d:{0}", this.getClass().getCanonicalName()));
            log.info(() -> MessageFormat.format("\u4f5c\u4e1a\u540d\u79f0:{0}", jobName));
            log.info(() -> MessageFormat.format("\u4f5c\u4e1a\u4efb\u52a1ID:{0}", taskId));
            log.info(() -> MessageFormat.format("\u5206\u7247\u603b\u6570:{0}", shardingTotalCount));
            log.info(() -> MessageFormat.format("\u5206\u914d\u4e8e\u672c\u4f5c\u4e1a\u5b9e\u4f8b\u7684\u5206\u7247\u9879:{0}", shardingItem));
            log.info(() -> MessageFormat.format("\u5206\u914d\u4e8e\u672c\u4f5c\u4e1a\u5b9e\u4f8b\u7684\u5206\u7247\u53c2\u6570:{0}", shardingParameter));
            log.info(() -> MessageFormat.format("\u4f5c\u4e1a\u81ea\u5b9a\u4e49\u53c2\u6570:{0}", jobParameter));
        }
        JSONObject jsonObject = JSONObject.parseObject((String)jobParameter);
        JSONObject pythonParam = jsonObject.getJSONObject("PYTHON_PARAM");
        String pythonHost = jsonObject.getString("PYTHON_HOST");
        Integer pythonPort = Optional.ofNullable(jsonObject.getInteger("PYTHON_PORT")).orElse(22);
        String pythonUserName = jsonObject.getString("PYTHON_USER_NAME");
        String pythonPassword = jsonObject.getString("PYTHON_PASSWORD");
        String pythonAddress = jsonObject.getString("PYTHON_ADDRESS");
        String pythonEncoding = Optional.ofNullable(jsonObject.getString("PYTHON_ENCODING")).orElse("UTF-8");
        Integer pythonVersion = jsonObject.getInteger("PYTHON_VERSION");
        Integer isRetry = jsonObject.getInteger("IS_RETRY");
        Integer timeout = jsonObject.getInteger("TIMEOUT");
        Integer retryCount = jsonObject.getInteger("RETRY_COUNT");
        Long businessId = jsonObject.getLong("BUSINESS_ID");
        pythonParam.put("SHARDING_ITEM", (Object)shardingItem);
        pythonParam.put("SHARDING_PARAMETER", (Object)shardingParameter);
        pythonParam.put("JOB_NAME", (Object)jobName);
        pythonParam.put("JOB_TASK_ID", (Object)taskId);
        pythonParam.put("SHARDING_TOTAL_COUNT", (Object)shardingTotalCount);
        pythonParam.put("BUSINESS_ID", (Object)businessId);
        int currRetryCount = 1;
        String result = this.executionPython(pythonHost, pythonPort, pythonUserName, pythonPassword, pythonAddress, pythonEncoding, pythonVersion, pythonParam.toJSONString(), isRetry, retryCount, timeout, currRetryCount, String.valueOf(businessId), shardingItem, null);
        log.info("--------------------------------------------------------------------------------------------");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String executionPython(String host, int port, String userName, String password, String pythonAddress, String encoding, int pythonVersion, String params, Integer isRetry, Integer retryCount, Integer timeout, int currRetryCount, String businessId, int shardingItem, Exception exception) {
        block16: {
            if (Objects.equals(isRetry, 1) && currRetryCount == retryCount + 1) {
                String alarmInfo = exception == null ? "Python \u8c03\u7528\u5f02\u5e38" : ExceptionUtils.getStackTrace((Throwable)exception).substring(0, 1500);
                throw new RuntimeException(alarmInfo);
            }
            String cmds = "/usr/bin/env python" + pythonVersion + " " + pythonAddress + " " + params;
            Connection connection = null;
            Session session = null;
            InputStream stdout = null;
            try {
                connection = new Connection(host, port);
                int connectTimeout = timeout == null ? 3000 : timeout;
                connection.connect((ServerHostKeyVerifier)null, connectTimeout, 0);
                connection.authenticateWithPassword(userName, password);
                session = connection.openSession();
                session.execCommand(cmds);
                String string = "success";
                return string;
            }
            catch (Exception e) {
                log.error("=========================\u6267\u884cpython\u5931\u8d25");
                exception = e;
                if (Objects.equals(isRetry, 1)) {
                    this.executionPython(host, port, userName, password, pythonAddress, encoding, pythonVersion, params, isRetry, retryCount, timeout, ++currRetryCount, businessId, shardingItem, exception);
                    break block16;
                }
                String alarmInfo = exception == null ? "Python \u8c03\u7528\u5f02\u5e38" : ExceptionUtils.getStackTrace((Throwable)exception).substring(0, 1500);
                throw new RuntimeException(alarmInfo);
            }
            finally {
                if (stdout != null) {
                    try {
                        stdout.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (session != null) {
                    session.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
        }
        return "Fail";
    }
}

