/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.task.timing.lite.jobs;

import com.alibaba.dubbo.config.ApplicationConfig;
import com.alibaba.dubbo.config.ReferenceConfig;
import com.alibaba.dubbo.config.RegistryConfig;
import com.alibaba.dubbo.rpc.service.GenericService;
import com.alibaba.fastjson.JSONObject;
import com.dangdang.ddframe.job.api.ShardingContext;
import com.dangdang.ddframe.job.api.simple.SimpleJob;
import com.ohaotian.task.timing.business.service.UpdateBathJobDetailService;
import com.ohaotian.task.timing.business.service.bo.BatchJobDetailReqBO;
import java.text.MessageFormat;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;

@Service
@Scope(value="prototype")
public class DubboRealTimeTaskJob
implements SimpleJob {
    private static final Logger log = LogManager.getLogger(DubboRealTimeTaskJob.class);
    @Autowired
    private UpdateBathJobDetailService updateBathJobDetailService;

    private GenericService builDubboDynamicService(String applicationName, String zkAddress, String groupName, String interfaceName, String version, Integer timeout) {
        ApplicationConfig application = new ApplicationConfig();
        application.setName(applicationName);
        RegistryConfig registry = new RegistryConfig();
        registry.setAddress(zkAddress);
        ReferenceConfig reference = new ReferenceConfig();
        reference.setInterface(interfaceName);
        if (StringUtils.isNotBlank((CharSequence)groupName)) {
            reference.setGroup(groupName);
        }
        if (StringUtils.isNotBlank((CharSequence)version)) {
            reference.setVersion(version);
        }
        if (timeout != null) {
            reference.setTimeout(timeout);
        }
        reference.setApplication(application);
        reference.setRegistry(registry);
        reference.setGeneric(Boolean.valueOf(true));
        return (GenericService)reference.get();
    }

    public void execute(ShardingContext shardingContext) {
        String jobName = shardingContext.getJobName();
        String taskId = shardingContext.getTaskId();
        int shardingTotalCount = shardingContext.getShardingTotalCount();
        int shardingItem = shardingContext.getShardingItem();
        String shardingParameter = StringUtils.isBlank((CharSequence)shardingContext.getShardingParameter()) ? "" : shardingContext.getShardingParameter();
        String jobParameter = shardingContext.getJobParameter();
        if (log.isInfoEnabled()) {
            log.info("============================================================================================");
            log.info(() -> MessageFormat.format("\u7ebf\u7a0b\u540d\u79f0:{0}", Thread.currentThread().getName()));
            log.info(() -> MessageFormat.format("Job\u7c7b\u540d:{0}", this.getClass().getCanonicalName()));
            log.info(() -> MessageFormat.format("\u4f5c\u4e1a\u540d\u79f0:{0}", jobName));
            log.info(() -> MessageFormat.format("\u4f5c\u4e1a\u4efb\u52a1ID:{0}", taskId));
            log.info(() -> MessageFormat.format("\u5206\u7247\u603b\u6570:{0}", shardingTotalCount));
            log.info(() -> MessageFormat.format("\u5206\u914d\u4e8e\u672c\u4f5c\u4e1a\u5b9e\u4f8b\u7684\u5206\u7247\u9879:{0}", shardingItem));
            log.info(() -> MessageFormat.format("\u5206\u914d\u4e8e\u672c\u4f5c\u4e1a\u5b9e\u4f8b\u7684\u5206\u7247\u53c2\u6570:{0}", shardingParameter));
            log.info(() -> MessageFormat.format("\u4f5c\u4e1a\u81ea\u5b9a\u4e49\u53c2\u6570:{0}", jobParameter));
        }
        JSONObject jsonJobParamJson = JSONObject.parseObject((String)jobParameter);
        String url = jsonJobParamJson.getString("HTTP_SERVER_ADDRESS");
        String method = jsonJobParamJson.getString("HTTP_METHOD");
        String shardingParameterReal = shardingParameter.replaceAll("#", ",");
        JSONObject jsonShardingParameter = JSONObject.parseObject((String)shardingParameterReal);
        int groupCount = jsonShardingParameter.getInteger("GROUP_COUNT");
        String busiDataJson = jsonShardingParameter.getString("BUSI_DATA_JSON");
        String batchNo = jsonShardingParameter.getString("BATCH_NO");
        JSONObject jsonObject = JSONObject.parseObject((String)jobParameter);
        JSONObject dubboParam = jsonObject.getJSONObject("DUBBO_PARAM");
        String dubboParamType = jsonObject.getString("DUBBO_PARAM_TYPE");
        Integer dubboTimeOut = jsonObject.getInteger("DUBBO_TIME_OUT");
        String dubboGroup = jsonObject.getString("DUBBO_GROUP");
        String dubboServiceName = jsonObject.getString("DUBBO_SERVICE_NAME");
        String dubboMethod = jsonObject.getString("DUBBO_METHOD");
        String dubboVersion = jsonObject.getString("DUBBO_VERSION");
        String dubboZkAddress = jsonObject.getString("DUBBO_ZK_ADDRESS");
        String dubboApplicationName = jsonObject.getString("DUBBO_APPLICATION_NAME");
        Long businessId = jsonObject.getLong("BUSINESS_ID");
        try {
            GenericService genericService = this.builDubboDynamicService(dubboApplicationName, dubboZkAddress, dubboGroup, dubboServiceName, dubboVersion, dubboTimeOut);
            Object result = genericService.$invoke(dubboMethod, new String[]{dubboParamType}, new Object[]{busiDataJson});
            System.out.println("dubbo\u5b9e\u65f6\u4e1a\u52a1\u8fd4\u56de\u53c2\u6570" + result);
            if (groupCount == 0) {
                BatchJobDetailReqBO bo = new BatchJobDetailReqBO();
                String taskDetailId = jsonShardingParameter.getString("TASK_DETAIL_ID");
                bo.setRspBody((String)result);
                bo.setBatchNo(batchNo);
                bo.setTaskDetailId(Long.valueOf(taskDetailId));
                bo.setCallStatus("200");
                this.updateBathJobDetailService.updateBatchJobDetail(bo);
                this.updateBathJobDetailService.updateRedisAndStore(batchNo);
            } else {
                BatchJobDetailReqBO batchBo = new BatchJobDetailReqBO();
                batchBo.setRspBody((String)result);
                batchBo.setBatchNo(batchNo);
                batchBo.setCallStatus("200");
                this.updateBathJobDetailService.updateBatchJobDetail(batchBo);
                this.updateBathJobDetailService.updateRedisAndStore(batchNo);
            }
        }
        catch (Exception ex) {
            log.error(() -> MessageFormat.format("\u5b9a\u65f6\u4efb\u52a1:{0}.\u6267\u884c\u5f02\u5e38:{1}", this.getClass().getCanonicalName(), ex));
            ex.printStackTrace();
        }
        log.info("--------------------------------------------------------------------------------------------");
    }
}

