/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.task.timing.lite.jobs;

import com.alibaba.fastjson.JSONObject;
import com.dangdang.ddframe.job.api.ShardingContext;
import com.dangdang.ddframe.job.api.simple.SimpleJob;
import com.taobao.hsf.app.api.util.HSFApiConsumerBean;
import com.taobao.hsf.remoting.service.GenericService;
import com.taobao.hsf.util.PojoUtils;
import java.text.MessageFormat;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;

@Service
@Scope(value="prototype")
public class HSFTimedTaskJob
implements SimpleJob {
    private static final Logger log = LogManager.getLogger(HSFTimedTaskJob.class);

    public void execute(ShardingContext shardingContext) {
        String jobName = shardingContext.getJobName();
        String taskId = shardingContext.getTaskId();
        int shardingTotalCount = shardingContext.getShardingTotalCount();
        int shardingItem = shardingContext.getShardingItem();
        String shardingParameter = StringUtils.isBlank((CharSequence)shardingContext.getShardingParameter()) ? "" : shardingContext.getShardingParameter();
        String jobParameter = shardingContext.getJobParameter();
        if (log.isInfoEnabled()) {
            log.info("============================================================================================");
            log.info(() -> MessageFormat.format("\u7ebf\u7a0b\u540d\u79f0:{0}", Thread.currentThread().getName()));
            log.info(() -> MessageFormat.format("Job\u7c7b\u540d:{0}", this.getClass().getCanonicalName()));
            log.info(() -> MessageFormat.format("\u4f5c\u4e1a\u540d\u79f0:{0}", jobName));
            log.info(() -> MessageFormat.format("\u4f5c\u4e1a\u4efb\u52a1ID:{0}", taskId));
            log.info(() -> MessageFormat.format("\u5206\u7247\u603b\u6570:{0}", shardingTotalCount));
            log.info(() -> MessageFormat.format("\u5206\u914d\u4e8e\u672c\u4f5c\u4e1a\u5b9e\u4f8b\u7684\u5206\u7247\u9879:{0}", shardingItem));
            log.info(() -> MessageFormat.format("\u5206\u914d\u4e8e\u672c\u4f5c\u4e1a\u5b9e\u4f8b\u7684\u5206\u7247\u53c2\u6570:{0}", shardingParameter));
            log.info(() -> MessageFormat.format("\u4f5c\u4e1a\u81ea\u5b9a\u4e49\u53c2\u6570:{0}", jobParameter));
        }
        JSONObject jsonObject = JSONObject.parseObject((String)jobParameter);
        JSONObject hsfParam = jsonObject.getJSONObject("HSF_PARAM");
        String hsfParamType = jsonObject.getString("HSF_PARAM_TYPE");
        Integer hsfTimeOut = jsonObject.getInteger("HSF_TIME_OUT");
        String hsfGroup = jsonObject.getString("HSF_GROUP");
        String hsfServiceName = jsonObject.getString("HSF_SERVICE_NAME");
        String hsfMethod = jsonObject.getString("HSF_METHOD");
        String hsfVersion = jsonObject.getString("HSF_VERSION");
        String businessId = jsonObject.getString("BUSINESS_ID");
        hsfParam.put("SHARDING_ITEM", (Object)shardingItem);
        hsfParam.put("SHARDING_PARAMETER", (Object)shardingParameter);
        hsfParam.put("JOB_NAME", (Object)jobName);
        hsfParam.put("JOB_TASK_ID", (Object)taskId);
        hsfParam.put("SHARDING_TOTAL_COUNT", (Object)shardingTotalCount);
        hsfParam.put("BUSINESS_ID", (Object)businessId);
        try {
            GenericService genericService = this.buildHsfDynamicService(hsfGroup, hsfServiceName, hsfVersion, hsfTimeOut);
            genericService.$invoke(hsfMethod, new String[]{hsfParamType}, PojoUtils.generalize((Object[])new Object[]{hsfParam}));
        }
        catch (Exception ex) {
            log.error(() -> MessageFormat.format("\u5b9a\u65f6\u4efb\u52a1:{0}.\u6267\u884c\u5f02\u5e38:{1}", this.getClass().getCanonicalName(), ex));
            throw new RuntimeException(ex.getMessage());
        }
        log.info("--------------------------------------------------------------------------------------------");
    }

    private GenericService buildHsfDynamicService(String groupName, String interfaceName, String version, Integer timeout) throws Exception {
        HSFApiConsumerBean consumerBean = new HSFApiConsumerBean();
        consumerBean.setInterfaceName(interfaceName);
        consumerBean.setGeneric("true");
        consumerBean.setVersion(version);
        consumerBean.setGroup(groupName);
        consumerBean.setClientTimeout(timeout.intValue());
        consumerBean.setMaxWaitTimeForCsAddress(30000);
        consumerBean.init();
        GenericService service = (GenericService)consumerBean.getObject();
        return service;
    }
}

