/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.task.timing.lite.service.impl;

import com.ohaotian.task.timing.lite.config.LiteRegistryCenterProperties;
import com.ohaotian.task.timing.lite.domain.mapper.ShardingItemExecLogDAO;
import com.ohaotian.task.timing.lite.domain.po.ShardingItemExecLogPO;
import com.ohaotian.task.timing.lite.service.UpdateShardingItemExecLogService;
import com.ohaotian.task.timing.lite.utils.DistributedLockUtil;
import java.util.List;
import org.apache.curator.framework.CuratorFramework;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UpdateShardingItemExecLogServiceImpl
implements UpdateShardingItemExecLogService {
    private static final Logger log = LoggerFactory.getLogger(UpdateShardingItemExecLogServiceImpl.class);
    @Autowired
    private ShardingItemExecLogDAO shardingItemExecLogDAO;
    @Autowired
    private DistributedLockUtil distributedLockUtil;
    @Autowired
    private CuratorFramework zkClient;
    @Autowired
    private LiteRegistryCenterProperties registryCenterProperties;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int updateShardingItemExecLog(String ip) {
        log.info(">>>>>>>>> Ready to lite offline processing ...");
        String lockKey = String.format("LITE_OFFLINE_IP_LOCK_%s", ip);
        boolean isLockSuccess = this.distributedLockUtil.lock(lockKey);
        if (!isLockSuccess) {
            log.warn(">>>>>>>>> Get the lock of {} fail.", (Object)lockKey);
            return 0;
        }
        try {
            List<ShardingItemExecLogPO> pos = this.shardingItemExecLogDAO.findAllExecutingJobByIp(ip);
            int count = this.shardingItemExecLogDAO.updateStatusByIp(ip);
            pos.forEach(item -> {
                String nodeName = item.getJobName() + "@-@" + item.getShardingItem();
                try {
                    this.zkClient.delete().forPath(this.registryCenterProperties.getShardingTriggerNode() + "/" + nodeName);
                }
                catch (Exception e) {
                    log.error(">>>>>>>>>> Delete the node: {} fail", (Object)nodeName, (Object)e);
                }
            });
            int n = count;
            return n;
        }
        finally {
            this.distributedLockUtil.unlock(lockKey);
            log.info(">>>>>>>>> Lite offline processing end ...");
        }
    }
}

