/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.task.timing.business.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.cache.CacheClient;
import com.ohaotian.task.timing.business.constant.BusiConstants;
import com.ohaotian.task.timing.business.dao.BatchJobDAO;
import com.ohaotian.task.timing.business.dao.BatchJobDetailDAO;
import com.ohaotian.task.timing.business.dao.po.BatchJobDetailPO;
import com.ohaotian.task.timing.business.dao.po.BatchJobPO;
import com.ohaotian.task.timing.business.service.UpdateBathJobDetailService;
import com.ohaotian.task.timing.business.service.bo.BatchJobDetailReqBO;
import java.util.Date;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="updateBathJobDetailService")
public class UpdateBatchDetailServiceImpl
implements UpdateBathJobDetailService {
    private static final Logger log = LogManager.getLogger(UpdateBatchDetailServiceImpl.class);
    @Autowired
    private BatchJobDetailDAO batchJobDetailDAO;
    @Autowired
    private BatchJobDAO batchJobDAO;
    @Autowired
    private CacheClient cacheClient;

    @Override
    public void updateBatchJobDetail(BatchJobDetailReqBO batchJobDetailReqBO) {
        Object record;
        log.debug("\u56de\u66f4\u6279\u6b21\u8868\u660e\u7ec6\u8868\u7684\u6570\u636e\u5f00\u59cb\u5165\u53c2BatchJobDetailReqBO:" + batchJobDetailReqBO);
        String batchNo = batchJobDetailReqBO.getBatchNo();
        log.debug("batchNo=" + batchNo);
        String key = batchNo + "_STATUS";
        Integer batchstatus = (Integer)this.cacheClient.get(key);
        Long batchTotal = (Long)this.cacheClient.get(batchNo + "_TOTAL");
        if (BusiConstants.BATCH_STATUS_1.equals(batchstatus)) {
            record = new BatchJobPO();
            ((BatchJobPO)record).setBatchNo(batchNo);
            ((BatchJobPO)record).setStatus(BusiConstants.BATCH_STATUS_2);
            this.batchJobDAO.updateByPrimaryKeySelective((BatchJobPO)record);
            this.cacheClient.put(key, (Object)BusiConstants.BATCH_STATUS_2);
        }
        log.debug("batchJobDetailReqBO.getTaskDetailId()=" + batchJobDetailReqBO.getTaskDetailId());
        if (null != batchJobDetailReqBO.getTaskDetailId()) {
            try {
                record = new BatchJobDetailPO();
                String bodyJson = batchJobDetailReqBO.getRspBody();
                JSONObject json = JSONObject.parseObject((String)bodyJson);
                String respCode = json.getString("respCode");
                String respDesc = json.getString("respDesc");
                String orderId = json.getString("orderId");
                log.debug("record.batchNo=" + batchNo);
                ((BatchJobDetailPO)record).setBatchNo(batchNo);
                ((BatchJobDetailPO)record).setTaskDetailId(batchJobDetailReqBO.getTaskDetailId());
                ((BatchJobDetailPO)record).setServiceRspData(bodyJson);
                ((BatchJobDetailPO)record).setCallStatus(Integer.valueOf(batchJobDetailReqBO.getCallStatus()));
                ((BatchJobDetailPO)record).setOrderNo(orderId);
                ((BatchJobDetailPO)record).setRespCode(respCode);
                ((BatchJobDetailPO)record).setRespDesc(respDesc);
                ((BatchJobDetailPO)record).setStatus(BusiConstants.BATCH_STATUS_3);
                ((BatchJobDetailPO)record).setOptTime(new Date());
                log.debug("record=" + record.toString() + "respCode" + respCode);
                if ("200".equals(batchJobDetailReqBO.getCallStatus()) && "0000".equals(respCode)) {
                    this.batchJobDetailDAO.updateByDetailId((BatchJobDetailPO)record);
                    this.cacheClient.incr(batchNo + "_SUCCESS");
                } else {
                    ((BatchJobDetailPO)record).setStatus(BusiConstants.BATCH_STATUS_4);
                    this.batchJobDetailDAO.updateByDetailId((BatchJobDetailPO)record);
                    this.cacheClient.incr(batchNo + "_FAIL");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                log.error("\u56de\u66f4\u6279\u6b21\u660e\u7ec6\u8868\u5904\u7406\u5f02\u5e38", (Throwable)e);
            }
        }
        if (null == batchJobDetailReqBO.getTaskDetailId()) {
            try {
                String rspB = batchJobDetailReqBO.getRspBody();
                JSONObject info = (JSONObject)JSONObject.parse((String)rspB);
                JSONArray array = (JSONArray)info.get((Object)"info");
                for (int i = 0; i < array.size(); ++i) {
                    BatchJobDetailPO detailPO = new BatchJobDetailPO();
                    JSONObject json = JSONObject.parseObject((String)array.get(i).toString());
                    log.debug("=" + array.getString(i));
                    log.debug("=**" + array.get(i).toString());
                    detailPO.setServiceRspData(array.getString(i));
                    detailPO.setOrderNo((String)json.get((Object)"orderId"));
                    detailPO.setOptTime(new Date());
                    detailPO.setDeviceNumber((String)json.get((Object)"deviceNumber"));
                    detailPO.setIccid((String)json.get((Object)"iccid"));
                    detailPO.setBatchNo(batchNo);
                    detailPO.setOptTime(new Date());
                    if ("0000".equals(json.get((Object)"respCode"))) {
                        detailPO.setStatus(BusiConstants.BATCH_STATUS_3);
                        detailPO.setRespCode((String)json.get((Object)"respCode"));
                        detailPO.setRespDesc((String)json.get((Object)"respDesc"));
                        this.batchJobDetailDAO.updateByNumberIccid(detailPO);
                        this.cacheClient.incr(batchNo + "_SUCCESS");
                        continue;
                    }
                    detailPO.setStatus(BusiConstants.BATCH_STATUS_4);
                    detailPO.setRespCode((String)json.get((Object)"respCode"));
                    detailPO.setRespDesc((String)json.get((Object)"respDesc"));
                    this.batchJobDetailDAO.updateByNumberIccid(detailPO);
                    this.cacheClient.incr(batchNo + "_FAIL");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                log.error("\u5904\u7406\u5f02\u5e38", (Throwable)e);
            }
        }
    }

    @Override
    public void updateRedisAndStore(String batchNo) {
        String key = batchNo + "_STATUS";
        Long failCount = null == this.cacheClient.getIncr(batchNo + "_FAIL") ? 0L : this.cacheClient.getIncr(batchNo + "_FAIL");
        Long successCount = null == this.cacheClient.getIncr(batchNo + "_SUCCESS") ? 0L : this.cacheClient.getIncr(batchNo + "_SUCCESS");
        Long total = null == this.cacheClient.get(batchNo + "_TOTAL") ? 0L : (Long)this.cacheClient.get(batchNo + "_TOTAL");
        log.debug("batchNo=" + batchNo + ",total=" + total + ",successCount=" + successCount + ",failCount=" + failCount);
        if (total == failCount + successCount) {
            this.cacheClient.set(key, (Object)BusiConstants.BATCH_STATUS_3);
            BatchJobPO record = new BatchJobPO();
            record.setStatus(BusiConstants.BATCH_STATUS_3);
            record.setCountFailed((long)failCount);
            record.setCountSuccess((long)successCount);
            record.setBatchNo(batchNo);
            record.setFinishTime(new Date());
            this.batchJobDAO.updateByPrimaryKeySelective(record);
            log.debug("\u66f4\u65b0\u6279\u6b21\u8868\u4e2d\u8868\u4e2d\u6210\u529f\uff0c\u5931\u8d25\uff0c\u72b6\u6001\u4fe1\u606f\u5b8c\u6210");
        }
    }

    public static void main(String[] args) {
        String b = "{\n\"respCode\": \"0000\",\n\"respDesc\": \"\u6210\u529f\",\n\"info\": [{\n\"deviceNumber\": \"13010000001\",\n\"orderId\": \"201809140001\",\n\"respCode\": \"0000\",\n\"respDesc\": \"\u5f00\u6237\u6210\u529f\"\n},\n{\n\"deviceNumber\": \"13010000002\",\n\"orderId\": \"201809140001\",\n\"respCode\": \"0000\",\n\"respDesc\": \"\u5f00\u6237\u6210\u529f\"\n},\n{\n\"deviceNumber\": \"13010000003\",\n\"orderId\": \"\",\n\"respCode\": \"9999\",\n\"respDesc\": \"\u53f7\u7801\u9519\u8bef\"\n}\n]\n}\n";
        JSONObject tt = (JSONObject)JSONObject.parse((String)b);
        Object c = tt.get((Object)"info");
        System.out.println("===" + c);
    }
}

