/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.task.timing.lite.utils;

import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.locks.InterProcessMutex;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DistributedLockUtil {
    private static final Logger log = LoggerFactory.getLogger(DistributedLockUtil.class);
    @Autowired
    private CuratorFramework zkClient;
    private long delayTimeForClean = 1000L;
    public static final String ROOT_PATH = "/ROOT_LOCK/";
    private InterProcessMutex interProcessMutex = null;
    private static final ScheduledExecutorService executorService = Executors.newScheduledThreadPool(2);

    public boolean lock(String key) throws Exception {
        try {
            this.interProcessMutex = new InterProcessMutex(this.zkClient, ROOT_PATH + key);
            return this.interProcessMutex.acquire(3L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public void unlock(String key) {
        try {
            this.interProcessMutex.release();
        }
        catch (Throwable e) {
            log.error(e.getMessage(), e);
        }
        finally {
            executorService.schedule(new Cleaner(this.zkClient, ROOT_PATH + key), this.delayTimeForClean, TimeUnit.MILLISECONDS);
        }
    }

    static class Cleaner
    implements Runnable {
        CuratorFramework client;
        String path;

        public Cleaner(CuratorFramework client, String path) {
            this.client = client;
            this.path = path;
        }

        @Override
        public void run() {
            try {
                List list = (List)this.client.getChildren().forPath(this.path);
                if (list == null || list.isEmpty()) {
                    this.client.delete().forPath(this.path);
                }
            }
            catch (KeeperException.NoNodeException list) {
            }
            catch (KeeperException.NotEmptyException list) {
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }
}

