/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.venus.core;

import com.ohaotian.venus.entity.ClassLoadEntity;
import com.ohaotian.venus.entity.GcEntity;
import com.ohaotian.venus.entity.JstackEntity;
import com.ohaotian.venus.entity.KVEntity;
import com.ohaotian.venus.entity.ThreadEntity;
import com.ohaotian.venus.jvm.Jstack;
import com.ohaotian.venus.jvm.Jstat;
import com.ohaotian.venus.jvm.Server;
import com.ohaotian.venus.utils.ExecuteCmd;
import com.ohaotian.venus.utils.LogReaderUtils;
import com.ohaotian.venus.utils.Res;
import java.lang.management.ManagementFactory;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/actuator/info"})
public class CoreController {
    private Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
    @Value(value="${spring.application.name}")
    private String name;
    @Value(value="${actuator.log.path}")
    private String logUrl;

    @RequestMapping(value={"/alive"})
    public Res alive() {
        return Res.ok().put("status", (Object)"alive");
    }

    @RequestMapping(value={"/thread"})
    public Res thread() {
        String date = CoreController.time();
        try {
            JstackEntity info = Jstack.jstack();
            ThreadEntity entity = new ThreadEntity();
            entity.setId(Integer.valueOf(info.getId()));
            entity.setName(this.name);
            entity.setDate(date);
            entity.setTotal(info.getTotal());
            entity.setRUNNABLE(info.getRUNNABLE());
            entity.setTIMED_WAITING(info.getTIMED_WAITING());
            entity.setWAITING(info.getWAITING());
            return Res.ok().put("thread", (Object)entity);
        }
        catch (Exception e) {
            e.printStackTrace();
            return Res.error();
        }
    }

    @RequestMapping(value={"/classload"})
    public Res classload() {
        String date = CoreController.time();
        try {
            List<KVEntity> jstatClass = Jstat.jstatClass();
            ClassLoadEntity entity = new ClassLoadEntity();
            entity.setId(Integer.valueOf(CoreController.getPid()));
            entity.setName(this.name);
            entity.setDate(date);
            entity.setLoaded(jstatClass.get(0).getValue());
            entity.setBytes1(jstatClass.get(1).getValue());
            entity.setUnloaded(jstatClass.get(2).getValue());
            entity.setBytes2(jstatClass.get(3).getValue());
            entity.setTime1(jstatClass.get(4).getValue());
            entity.setCompiled(jstatClass.get(5).getValue());
            entity.setFailed(jstatClass.get(6).getValue());
            entity.setInvalid(jstatClass.get(7).getValue());
            entity.setTime2(jstatClass.get(8).getValue());
            return Res.ok().put("classload", (Object)entity);
        }
        catch (Exception e) {
            e.printStackTrace();
            return Res.error();
        }
    }

    @RequestMapping(value={"/gc"})
    public Res gc() {
        String date = CoreController.time();
        try {
            List<KVEntity> kvEntities = Jstat.jstatGc();
            GcEntity entity = new GcEntity();
            entity.setId(Integer.valueOf(CoreController.getPid()));
            entity.setName(this.name);
            entity.setDate(date);
            entity.setS0C(kvEntities.get(0).getValue());
            entity.setS1C(kvEntities.get(1).getValue());
            entity.setS0U(kvEntities.get(2).getValue());
            entity.setS1U(kvEntities.get(3).getValue());
            entity.setEC(kvEntities.get(4).getValue());
            entity.setEU(kvEntities.get(5).getValue());
            entity.setOC(kvEntities.get(6).getValue());
            entity.setOU(kvEntities.get(7).getValue());
            entity.setMC(kvEntities.get(8).getValue());
            entity.setMU(kvEntities.get(9).getValue());
            entity.setCCSC(kvEntities.get(10).getValue());
            entity.setCCSU(kvEntities.get(11).getValue());
            entity.setYGC(kvEntities.get(12).getValue());
            entity.setYGCT(kvEntities.get(13).getValue());
            entity.setFGC(kvEntities.get(14).getValue());
            entity.setFGCT(kvEntities.get(15).getValue());
            entity.setGCT(kvEntities.get(16).getValue());
            return Res.ok().put("gc", (Object)entity);
        }
        catch (Exception e) {
            e.printStackTrace();
            return Res.error();
        }
    }

    @RequestMapping(value={"/runexec"})
    public Res getRuntimeExec(@RequestParam Map<String, String> params) {
        try {
            ArrayList<String> list = new ArrayList<String>();
            for (String s : params.keySet()) {
                list.add(params.get(s));
            }
            Object[] array = list.toArray(new String[list.size()]);
            this.logger.debug("runexec:{}", (Object)Arrays.toString(array));
            String result = ExecuteCmd.execute((String[])array, new String[0]);
            return Res.ok().put("result", (Object)result);
        }
        catch (Exception e) {
            this.logger.debug("RuntimeExec\u5f02\u5e38\uff1a{}", (Throwable)e);
            return Res.error("RuntimeExec\u5f02\u5e38");
        }
    }

    @RequestMapping(value={"/logReader"})
    public Res logred(String url) {
        try {
            String msg = LogReaderUtils.poll(this.logUrl);
            return Res.ok().put("result", (Object)msg);
        }
        catch (Exception e) {
            this.logger.debug("RuntimeExec\u5f02\u5e38\uff1a{}", (Throwable)e);
            return Res.error("RuntimeExec\u5f02\u5e38");
        }
    }

    @RequestMapping(value={"/lastLogReader"})
    public Res pollReversedRow(@RequestParam Long rowNum) {
        try {
            List<String> msg = LogReaderUtils.pollReversedRow(this.logUrl, rowNum);
            Collections.reverse(msg);
            return Res.ok().put("result", (Object)msg);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.debug("RuntimeExec\u5f02\u5e38\uff1a{}", (Throwable)e);
            return Res.error("RuntimeExec\u5f02\u5e38");
        }
    }

    @RequestMapping(value={"/systemInfo"})
    public Res systemInfo() {
        try {
            Server server = new Server();
            server.copyTo();
            return Res.ok().put("server", (Object)server);
        }
        catch (Exception e) {
            this.logger.debug("systemInfo\u5f02\u5e38\uff1a{}", (Throwable)e);
            return Res.error("systemInfo\u5f02\u5e38");
        }
    }

    public static String time() {
        SimpleDateFormat format = new SimpleDateFormat("MM/dd HH:mm:ss");
        return format.format(new Date());
    }

    public static String getPid() {
        String name = ManagementFactory.getRuntimeMXBean().getName();
        String pid = name.split("@")[0];
        return pid;
    }
}

