/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.venus.core;

import com.ohaotian.venus.jvm.Jmap;
import com.ohaotian.venus.jvm.Jstack;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"/actuator/file"})
public class FileFileController {
    private Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());

    @RequestMapping(value={"/heap"})
    public ResponseEntity<byte[]> heapDump() throws IOException {
        String dump = Jmap.dump();
        File file = new File(dump);
        this.logger.debug("DownLoad Dump:" + dump);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_OCTET_STREAM);
        headers.setContentDispositionFormData("attachment", file.getName());
        return new ResponseEntity((Object)FileUtils.readFileToByteArray((File)file), (MultiValueMap)headers, HttpStatus.CREATED);
    }

    @RequestMapping(value={"/thread"})
    public ResponseEntity<byte[]> threadDump() throws IOException {
        String dump = Jstack.dump();
        File file = new File(dump);
        this.logger.debug("DownLoad Dump:" + dump);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_OCTET_STREAM);
        headers.setContentDispositionFormData("attachment", file.getName());
        return new ResponseEntity((Object)FileUtils.readFileToByteArray((File)file), (MultiValueMap)headers, HttpStatus.CREATED);
    }
}

