/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.venus.jvm;

import com.ohaotian.venus.entity.JstackEntity;
import com.ohaotian.venus.utils.ArrayUtil;
import com.ohaotian.venus.utils.ExecuteCmd;
import com.ohaotian.venus.utils.PathUtil;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.nio.charset.Charset;
import org.apache.commons.io.FileUtils;

public class Jstack {
    private static final String prefix = "java.lang.Thread.State: ";

    public static JstackEntity jstack() {
        String id = Jstack.getPid();
        String s = ExecuteCmd.execute(new String[]{"jstack", id}, new String[0]);
        int total = ArrayUtil.appearNumber(s, "nid=");
        int RUNNABLE = ArrayUtil.appearNumber(s, "java.lang.Thread.State: RUNNABLE");
        int TIMED_WAITING = ArrayUtil.appearNumber(s, "java.lang.Thread.State: TIMED_WAITING");
        int WAITING = ArrayUtil.appearNumber(s, "java.lang.Thread.State: WAITING");
        return new JstackEntity(id, total, RUNNABLE, TIMED_WAITING, WAITING);
    }

    public static String dump() throws IOException {
        String id = Jstack.getPid();
        String path = PathUtil.getRootPath("dump/" + id + "_thread.txt");
        String s = ExecuteCmd.execute(new String[]{"jstack", id}, new String[0]);
        File file = new File(path);
        FileUtils.write((File)file, (CharSequence)s, (Charset)Charset.forName("UTF-8"));
        return path;
    }

    public static String getPid() {
        String name = ManagementFactory.getRuntimeMXBean().getName();
        String pid = name.split("@")[0];
        return pid;
    }
}

