/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.venus.jvm;

import com.ohaotian.venus.entity.KVEntity;
import com.ohaotian.venus.utils.ArrayUtil;
import com.ohaotian.venus.utils.ExecuteCmd;
import java.io.BufferedReader;
import java.io.StringReader;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.List;

public class Jstat {
    private static List<KVEntity> jstat(String[] strings) throws Exception {
        ArrayList<KVEntity> list = new ArrayList<KVEntity>();
        String s = ExecuteCmd.execute(strings, new String[0]);
        assert (s != null);
        BufferedReader reader = new BufferedReader(new StringReader(s));
        String[] keys = ArrayUtil.trim(reader.readLine().split("\\s+|\t"));
        String[] values = ArrayUtil.trim(reader.readLine().split("\\s+|\t"));
        if (strings[1].equals("-compiler")) {
            for (int i = 0; i < 4; ++i) {
                list.add(new KVEntity(keys[i], values[i]));
            }
            return list;
        }
        for (int i = 0; i < keys.length; ++i) {
            list.add(new KVEntity(keys[i], values[i]));
        }
        return list;
    }

    public static List<KVEntity> jstatClass() throws Exception {
        String id = Jstat.getPid();
        List<KVEntity> jstatClass = Jstat.jstat(new String[]{"jstat", "-class", id});
        List<KVEntity> jstatCompiler = Jstat.jstat(new String[]{"jstat", "-compiler", id});
        jstatClass.addAll(jstatCompiler);
        return jstatClass;
    }

    public static List<KVEntity> jstatGc() throws Exception {
        String id = Jstat.getPid();
        return Jstat.jstat(new String[]{"jstat", "-gc", id});
    }

    public static List<KVEntity> jstatUtil() throws Exception {
        String id = Jstat.getPid();
        return Jstat.jstat(new String[]{"jstat", "-gcutil", id});
    }

    public static String getPid() {
        String name = ManagementFactory.getRuntimeMXBean().getName();
        String pid = name.split("@")[0];
        return pid;
    }
}

