/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.venus.jvm.server;

import com.ohaotian.venus.utils.Arith;
import java.lang.management.ManagementFactory;
import java.text.SimpleDateFormat;
import java.util.Date;

public class Jvm {
    private double total;
    private double max;
    private double free;
    private String version;
    private String home;

    public double getTotal() {
        return Arith.div(this.total, 1048576.0, 2);
    }

    public void setTotal(double total) {
        this.total = total;
    }

    public double getMax() {
        return Arith.div(this.max, 1048576.0, 2);
    }

    public void setMax(double max) {
        this.max = max;
    }

    public double getFree() {
        return Arith.div(this.free, 1048576.0, 2);
    }

    public void setFree(double free) {
        this.free = free;
    }

    public double getUsed() {
        return Arith.div(this.total - this.free, 1048576.0, 2);
    }

    public double getUsage() {
        return Arith.mul(Arith.div(this.total - this.free, this.total, 4), 100.0);
    }

    public String getName() {
        return ManagementFactory.getRuntimeMXBean().getVmName();
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getHome() {
        return this.home;
    }

    public void setHome(String home) {
        this.home = home;
    }

    public String getStartTime() {
        return Jvm.format(Jvm.getServerStartDate(), "yyyy-MM-dd HH:mm:ss");
    }

    public String getRunTime() {
        return Jvm.getDatePoor(new Date(), Jvm.getServerStartDate());
    }

    public String toString() {
        return "Jvm [total=" + this.total + ", max=" + this.max + ", free=" + this.free + ", version=" + this.version + ", home=" + this.home + "]";
    }

    public static String format(Date date, String pattern) {
        if (date != null) {
            SimpleDateFormat df = new SimpleDateFormat(pattern);
            return df.format(date);
        }
        return null;
    }

    public static String getDatePoor(Date endDate, Date nowDate) {
        long nd = 86400000L;
        long nh = 3600000L;
        long nm = 60000L;
        long diff = endDate.getTime() - nowDate.getTime();
        long day = diff / nd;
        long hour = diff % nd / nh;
        long min = diff % nd % nh / nm;
        return day + "\u5929" + hour + "\u5c0f\u65f6" + min + "\u5206\u949f";
    }

    public static Date getServerStartDate() {
        long time = ManagementFactory.getRuntimeMXBean().getStartTime();
        return new Date(time);
    }
}

