/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.venus.utils;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.RandomAccessFile;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.commons.io.input.ReversedLinesFileReader;

public class LogReaderUtils {
    private static String serialNumber = "-1";
    private static long lastTimeFileSize = 0L;
    private static BlockingQueue query = new LinkedBlockingQueue(10000);

    public static void run(String logUrl) {
        File logFile = new File(logUrl);
        try {
            long len = logFile.length();
            if (len < lastTimeFileSize) {
                lastTimeFileSize = len;
            } else if (len > lastTimeFileSize) {
                RandomAccessFile randomFile = new RandomAccessFile(logFile, "r");
                randomFile.seek(lastTimeFileSize);
                String tmp = null;
                while ((tmp = randomFile.readLine()) != null) {
                    query.add(new String(tmp.getBytes("ISO-8859-1"), "UTF-8"));
                }
                lastTimeFileSize = randomFile.length();
                randomFile.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String poll(String logUrl) {
        try {
            LogReaderUtils.run(logUrl);
            String msg = (String)query.take();
            return msg;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Long getLineNumber(File file) {
        if (file.exists()) {
            try {
                FileReader fileReader = new FileReader(file);
                LineNumberReader lineNumberReader = new LineNumberReader(fileReader);
                lineNumberReader.skip(Long.MAX_VALUE);
                long lines = lineNumberReader.getLineNumber() + 1;
                fileReader.close();
                lineNumberReader.close();
                return lines;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return 0L;
    }

    public static List<String> readReversedRow(String logUrl, Long rowNum) {
        File logFile = new File(logUrl);
        ArrayList<String> msg = new ArrayList<String>();
        int counter = 1;
        try {
            String lineStr;
            ReversedLinesFileReader linesFileReader = new ReversedLinesFileReader(logFile, 4096, "UTF-8");
            while ((long)counter <= rowNum && (lineStr = linesFileReader.readLine()) != null) {
                msg.add(lineStr.replace("\t", "    "));
                ++counter;
            }
            return msg;
        }
        catch (IOException e) {
            e.printStackTrace();
            return msg;
        }
    }

    public static List<String> pollReversedRow(String logUrl, Long rowNum) {
        return LogReaderUtils.readReversedRow(logUrl, rowNum);
    }

    public static String format(Date date) {
        return LogReaderUtils.format(date, "yyyy-MM-dd HH:mm:ss");
    }

    public static String format(Date date, String pattern) {
        if (date != null) {
            SimpleDateFormat df = new SimpleDateFormat(pattern);
            return df.format(date);
        }
        return null;
    }
}

