/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.async.call.future;

import com.tydic.async.call.bo.AsyncRequest;
import com.tydic.async.call.bo.Response;
import com.tydic.async.call.timer.HashedWheelTimer;
import com.tydic.async.call.timer.Timeout;
import com.tydic.async.call.timer.Timer;
import com.tydic.async.call.timer.TimerTask;
import com.tydic.async.call.utils.NamedThreadFactory;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAsyncFuture
extends CompletableFuture<Object> {
    private static final Logger log = LoggerFactory.getLogger(DefaultAsyncFuture.class);
    private static final Map<Long, DefaultAsyncFuture> FUTURES = new ConcurrentHashMap<Long, DefaultAsyncFuture>();
    private final Long id;
    private final AsyncRequest request;
    private final int timeout;
    private Object result;
    private Timeout timeoutCheckTask;
    private final long start = System.currentTimeMillis();
    private volatile long sent;
    public static final Timer TIME_OUT_TIMER = new HashedWheelTimer(new NamedThreadFactory("mq-future-timeout", true), 30L, TimeUnit.MILLISECONDS);

    private DefaultAsyncFuture(AsyncRequest request, int timeout) {
        this.request = request;
        this.id = request.getId();
        this.timeout = timeout > 0 ? timeout : request.getTimeOut();
        FUTURES.put(this.id, this);
    }

    private static void timeoutCheck(DefaultAsyncFuture future) {
        TimeoutCheckTask task = new TimeoutCheckTask(future.getId());
        future.timeoutCheckTask = TIME_OUT_TIMER.newTimeout(task, future.getTimeout(), TimeUnit.MILLISECONDS);
    }

    public static DefaultAsyncFuture newFuture(AsyncRequest request) {
        DefaultAsyncFuture future = new DefaultAsyncFuture(request, request.getTimeOut());
        DefaultAsyncFuture.timeoutCheck(future);
        return future;
    }

    public static DefaultAsyncFuture getFuture(long id) {
        return FUTURES.get(id);
    }

    public static void sent(AsyncRequest request) {
        DefaultAsyncFuture future = FUTURES.get(request.getId());
        if (future != null) {
            future.doSent();
        }
    }

    private void doSent() {
        this.sent = System.currentTimeMillis();
    }

    private boolean isSent() {
        return this.sent > 0L;
    }

    public static void received(Response response) {
        DefaultAsyncFuture.received(response, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void received(Response response, boolean timeout) {
        block7: {
            try {
                DefaultAsyncFuture future = DefaultAsyncFuture.getFuture(response.getId());
                if (future != null) {
                    future = FUTURES.remove(response.getId());
                    Timeout t = future.timeoutCheckTask;
                    if (!timeout) {
                        t.cancel();
                    }
                    future.doReceived(response);
                    break block7;
                }
                log.warn(" The response may not this slices request, so give up !!! The  response finally returned at " + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(new Date()) + ", response " + response);
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                FUTURES.remove(response.getId());
            }
        }
    }

    private void doReceived(Response res) {
        if (res == null) {
            throw new IllegalStateException("response cannot be null");
        }
        if (res.getStatus() == 20) {
            this.complete(res.getResult());
            this.result = res.getResult();
        } else if (res.getStatus() == 30 || res.getStatus() == 31) {
            this.completeExceptionally(new TimeoutException(res.getErrorMessage()));
        } else {
            this.completeExceptionally(new RuntimeException(res.getErrorMessage()));
        }
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        Response errorResult = new Response(this.id);
        errorResult.setStatus((byte)90);
        errorResult.setErrorMessage("request future has been canceled.");
        this.doReceived(errorResult);
        FUTURES.remove(this.id);
        return true;
    }

    public void cancel() {
        this.cancel(true);
    }

    private String getTimeoutMessage(boolean scan) {
        long nowTimestamp = System.currentTimeMillis();
        return (this.sent > 0L ? "Waiting server-side response timeout" : "Sending request timeout in client-side") + (scan ? " by scan timer" : "") + ". start time: " + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(new Date(this.start)) + ", end time: " + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(new Date()) + "," + (this.sent > 0L ? " client elapsed: " + (this.sent - this.start) + " ms, server elapsed: " + (nowTimestamp - this.sent) : " elapsed: " + (nowTimestamp - this.start)) + " ms, timeout: " + this.timeout + " ms, request: " + this.request;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DefaultAsyncFuture)) {
            return false;
        }
        DefaultAsyncFuture other = (DefaultAsyncFuture)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        AsyncRequest this$request = this.getRequest();
        AsyncRequest other$request = other.getRequest();
        if (this$request == null ? other$request != null : !((Object)this$request).equals(other$request)) {
            return false;
        }
        if (this.getTimeout() != other.getTimeout()) {
            return false;
        }
        Object this$result = this.getResult();
        Object other$result = other.getResult();
        if (this$result == null ? other$result != null : !this$result.equals(other$result)) {
            return false;
        }
        Timeout this$timeoutCheckTask = this.getTimeoutCheckTask();
        Timeout other$timeoutCheckTask = other.getTimeoutCheckTask();
        if (this$timeoutCheckTask == null ? other$timeoutCheckTask != null : !this$timeoutCheckTask.equals(other$timeoutCheckTask)) {
            return false;
        }
        if (this.getStart() != other.getStart()) {
            return false;
        }
        return this.getSent() == other.getSent();
    }

    protected boolean canEqual(Object other) {
        return other instanceof DefaultAsyncFuture;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        AsyncRequest $request = this.getRequest();
        result = result * 59 + ($request == null ? 43 : ((Object)$request).hashCode());
        result = result * 59 + this.getTimeout();
        Object $result = this.getResult();
        result = result * 59 + ($result == null ? 43 : $result.hashCode());
        Timeout $timeoutCheckTask = this.getTimeoutCheckTask();
        result = result * 59 + ($timeoutCheckTask == null ? 43 : $timeoutCheckTask.hashCode());
        long $start = this.getStart();
        result = result * 59 + (int)($start >>> 32 ^ $start);
        long $sent = this.getSent();
        result = result * 59 + (int)($sent >>> 32 ^ $sent);
        return result;
    }

    public Long getId() {
        return this.id;
    }

    public AsyncRequest getRequest() {
        return this.request;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public Object getResult() {
        return this.result;
    }

    public Timeout getTimeoutCheckTask() {
        return this.timeoutCheckTask;
    }

    public long getStart() {
        return this.start;
    }

    public long getSent() {
        return this.sent;
    }

    public void setResult(Object result) {
        this.result = result;
    }

    public void setTimeoutCheckTask(Timeout timeoutCheckTask) {
        this.timeoutCheckTask = timeoutCheckTask;
    }

    public void setSent(long sent) {
        this.sent = sent;
    }

    @Override
    public String toString() {
        return "DefaultAsyncFuture(id=" + this.getId() + ", request=" + this.getRequest() + ", timeout=" + this.getTimeout() + ", result=" + this.getResult() + ", timeoutCheckTask=" + this.getTimeoutCheckTask() + ", start=" + this.getStart() + ", sent=" + this.getSent() + ")";
    }

    private static class TimeoutCheckTask
    implements TimerTask {
        private final Long requestID;

        TimeoutCheckTask(Long requestID) {
            this.requestID = requestID;
        }

        @Override
        public void run(Timeout timeout) {
            DefaultAsyncFuture future = DefaultAsyncFuture.getFuture(this.requestID);
            if (future == null || future.isDone()) {
                return;
            }
            Response timeoutResponse = new Response(future.getId());
            timeoutResponse.setStatus(future.isSent() ? (byte)31 : 30);
            timeoutResponse.setErrorMessage(future.getTimeoutMessage(true));
            DefaultAsyncFuture.received(timeoutResponse, true);
        }
    }
}

