package com.tydic.async.exterior.config;

import cn.hutool.core.convert.Convert;
import com.ohaotian.plugin.mq.proxy.DefaultProxyMessageConfig;
import com.ohaotian.plugin.mq.proxy.impl.ProxyProducerFactoryBean;
import com.tydic.async.exterior.config.mq.ExteriorMqConsumer;
import com.tydic.async.exterior.properties.ExteriorCallProperties;
import com.tydic.async.exterior.properties.ExteriorInvokeProperties;
import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * 标题：类名称:ExteriorMqConfiguration
 * 说明：描述一下类的作用TODO
 * 时间：2022/1/10 4:00 PM
 * 作者 @author hegy2017
 */
@Configuration
@RequiredArgsConstructor(onConstructor = @__(@Autowired))
public class ExteriorMqConfiguration {

    @Autowired
    private ExteriorCallProperties callProperties;

    @Autowired
    private ExteriorInvokeProperties invokeProperties;

    @Bean("defaultExteriorProxyMessageConfig")
    public DefaultProxyMessageConfig defaultProxyMessageConfig() {
        DefaultProxyMessageConfig defaultProxyMessageConfig = new DefaultProxyMessageConfig();
        defaultProxyMessageConfig.setId(callProperties.getPid());
        return defaultProxyMessageConfig;
    }

    @Bean(value = "exteriorProvider", initMethod = "startup", destroyMethod = "shutdown")
    public ProxyProducerFactoryBean exteriorProducerFactoryBean() {
        ProxyProducerFactoryBean proxyProducerFactoryBean = new ProxyProducerFactoryBean();
        proxyProducerFactoryBean.setMessageConfig(defaultProxyMessageConfig());
        return proxyProducerFactoryBean;
    }

    @Bean
    public ExteriorMqConsumer exteriorMqConsumer() {
        ExteriorMqConsumer exteriorMqConsumer = new ExteriorMqConsumer();
        exteriorMqConsumer.setId(invokeProperties.getPid());
        exteriorMqConsumer.setTags(Convert.toStrArray(invokeProperties.getTag()));
        exteriorMqConsumer.setSubject(invokeProperties.getTopic());
        return exteriorMqConsumer;
    }
}
