package com.tydic.async.exterior.properties;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;

import java.io.Serializable;

/**
 * 标题：类名称:ExteriorCallProperties
 * 说明：外网链接的消息队列配置信息
 * 时间：2022/1/10 3:10 PM
 * 作者 @author hegy2017
 */
@Data
@ConfigurationProperties(prefix = "exterior.mq.call")
public class ExteriorCallProperties implements Serializable {

    private static final long serialVersionUID = 7290144898412355753L;
    /**
     * 队列主题
     */
    private String topic;

    /**
     * 队列标签
     */
    private String tag;

    /**
     * 队列ID
     */
    private String pid;

    /**
     * 队列模式
     */
    private String model;

    /**
     * 调用超时时间,单位毫秒
     */
    private Integer timeout;


}
