/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.venus.extension.handler;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public class DynamicProxyFactory {
    public static <T> T createProxy(Class<T> interfaceClass) {
        return (T)Proxy.newProxyInstance(interfaceClass.getClassLoader(), new Class[]{interfaceClass}, (InvocationHandler)new EmptyInvocationHandler());
    }

    static class EmptyInvocationHandler
    implements InvocationHandler {
        EmptyInvocationHandler() {
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (!method.getReturnType().equals(Void.TYPE)) {
                if (method.getReturnType().equals(String.class)) {
                    return "";
                }
                if (method.getReturnType().equals(Integer.TYPE)) {
                    return 0;
                }
            }
            return null;
        }
    }
}

