/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.venus.extension.handler;

import com.ohaotian.venus.extension.Extension;
import com.ohaotian.venus.extension.ExtensionProperties;
import com.ohaotian.venus.extension.handler.DynamicProxyFactory;
import com.ohaotian.venus.extension.handler.ExtensionAnnotationHandle;
import com.ohaotian.venus.extension.processor.ExtensionRepository;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class ExtensionAnnotationHandler
implements ExtensionAnnotationHandle,
ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(ExtensionAnnotationHandler.class);
    private ApplicationContext applicationContext;
    @Autowired
    private ExtensionProperties extensionProperties;
    @Autowired
    private ExtensionRepository repository;

    @Override
    public boolean hasExist(Field field) {
        if (field == null) {
            return false;
        }
        for (Annotation annotation : field.getDeclaredAnnotations()) {
            if (!(annotation instanceof Extension)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object invoke(Object bean, Field field) {
        try {
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            if (field.isAnnotationPresent(Extension.class)) {
                Extension extensionAnnotation = field.getAnnotation(Extension.class);
                String originalBeanName = extensionAnnotation.name();
                String extensionBeanName = field.getType().getSimpleName();
                log.debug("\u53d1\u73b0\u6ce8\u89e3@Extension,\u89e3\u6790\u540e\u7684\u4fe1\u606f\u4e3a\uff1aoriginalBeanName=" + originalBeanName + ",\u6269\u5c55\u4fe1\u606fextensionBeanName=" + extensionBeanName);
                if (!this.hasExtensionBean(extensionBeanName)) {
                    Object value;
                    if (!this.hasOriginalBean(originalBeanName)) {
                        value = field.getType().cast(DynamicProxyFactory.createProxy(field.getType()));
                        log.debug("\u6ca1\u6709\u6269\u5c55\u5b9e\u73b0\uff0c\u6ca1\u6709\u4ea7\u54c1\u9ed8\u8ba4\u5b9e\u73b0,\u8bf7\u6ce8\u610f\uff0c\u8d4b\u503c\u4e3a\u7a7a\uff01\uff01\uff01\uff01\uff01\uff01\uff1a");
                    } else {
                        Object tempValue = this.repository.getOriginalRepo().get(ExtensionAnnotationHandler.convertFirstLetterToLowerCase(originalBeanName));
                        value = field.getType().cast(tempValue);
                        log.debug("\u6ca1\u6709\u6269\u5c55\u5b9e\u73b0\uff0c\u6709\u4ea7\u54c1\u7684\u9ed8\u8ba4\u5b9e\u73b0,\u4f7f\u7528\u4ea7\u54c1\u5b9e\u73b0\uff1a" + originalBeanName + ",\u627e\u5230\u5bf9\u8c61\u5bf9\u8c61\u7684\u540d\u79f0\uff1a" + value.getClass().getSimpleName());
                    }
                    field.setAccessible(true);
                    field.set(bean, value);
                } else {
                    log.debug("\u627e\u5230\u6269\u5c55\u5b9e\u73b0\uff0c\u4f7f\u7528\u6269\u5c55\u7684\u5b9e\u73b0\uff1a" + bean.getClass().getSimpleName());
                }
            }
            return bean;
        }
        catch (Exception e) {
            log.error("Failed to init  at filed " + field.getName() + " in class " + bean.getClass().getName() + ", cause: " + e.getMessage(), (Throwable)e);
            return bean;
        }
    }

    @Override
    public void repository(Object bean, Field field) {
        try {
            if (field.isAnnotationPresent(Extension.class)) {
                Extension extensionAnnotation = field.getAnnotation(Extension.class);
                Class<?> fieldType = field.getType();
                String extBeanName = fieldType.getSimpleName();
                String originalBeanName = StringUtils.isEmpty((Object)extensionAnnotation.name()) ? extBeanName.substring(0, extBeanName.length() - 5) : extensionAnnotation.name();
                this.repositoryOriginalBean(originalBeanName);
                this.repositoryExtensionBean(extBeanName);
            }
        }
        catch (Exception e) {
            log.error("Failed to repository " + field.getName() + " in class " + bean.getClass().getName() + ", cause: " + e.getMessage(), (Throwable)e);
        }
    }

    private boolean hasOriginalBean(String clazzName) {
        clazzName = ExtensionAnnotationHandler.convertFirstLetterToLowerCase(clazzName);
        return this.repository.getOriginalRepo().containsKey(clazzName);
    }

    public static String convertFirstLetterToLowerCase(String input) {
        if (input == null || input.isEmpty()) {
            return input;
        }
        char firstChar = input.charAt(0);
        if (Character.isUpperCase(firstChar)) {
            return Character.toLowerCase(firstChar) + input.substring(1);
        }
        return input;
    }

    private void repositoryOriginalBean(String clazzName) {
        clazzName = ExtensionAnnotationHandler.convertFirstLetterToLowerCase(clazzName);
        if (!this.repository.getOriginalRepo().containsKey(clazzName)) {
            try {
                Object bean = this.applicationContext.getBean(clazzName + "Impl");
                this.repository.getOriginalRepo().put(clazzName, bean);
            }
            catch (Exception e) {
                log.debug("\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u5b9e\u73b0:" + clazzName + "Impl");
            }
        }
    }

    private void repositoryExtensionBean(String clazzName) {
        String extBeans;
        List<String> extBeanList;
        if (!this.repository.getExtensionRepo().containsKey(clazzName) && !StringUtils.isEmpty((Object)this.extensionProperties.getExtBeans()) && !(extBeanList = Arrays.asList((extBeans = this.extensionProperties.getExtBeans()).split(","))).isEmpty() && extBeanList.contains(clazzName)) {
            this.repository.getExtensionRepo().put(clazzName, Boolean.TRUE);
        }
    }

    private boolean hasExtensionBean(String clazzName) {
        return this.repository.getExtensionRepo().containsKey(clazzName);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

