/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.venus.extension.scanner;

import com.ohaotian.venus.extension.IExtensionPoint;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(name={"ext.config.ext-service"}, havingValue="true")
public class ExtensionBeanScanner
implements ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(ExtensionBeanScanner.class);
    private ApplicationContext context;

    @PostConstruct
    public void init() {
        String[] beanNames;
        for (String beanName : beanNames = this.context.getBeanDefinitionNames()) {
            Object bean = this.context.getBean(beanName);
            StringBuilder sb = new StringBuilder();
            if (bean instanceof IExtensionPoint) {
                log.debug("\u5f00\u59cb\u626b\u63cf\u6269\u5c55\u670d\u52a1\u91cc\u9762\uff0c\u5b9e\u73b0\u4e86IExtensionPoint\u7684\u6240\u6709bean\uff0c\u7528\u4e8e\u4ea7\u54c1\u670d\u52a1\u5224\u5b9a\u662f\u5426\u6709\u6269\u5c55.");
                sb.append(bean.getClass().getSimpleName());
                sb.append(",");
            }
            log.info("\u6240\u6709\u7684\u6269\u5c55\u7c7b\u540d\u79f0\u4e3a\uff1a" + sb);
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = applicationContext;
    }
}

