package com.ohaotian.venus.extension.handler;

import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

/**
 * 标题：类名称:DynamicProxyFactory
 * 说明：描述一下类的作用TODO
 * 时间：2023/8/10 8:23 PM
 * 作者 @author hegy2017
 */
public class DynamicProxyFactory {

    @SuppressWarnings("unchecked")
    public static <T> T createProxy(Class<T> interfaceClass) {
        return (T) Proxy.newProxyInstance(
                interfaceClass.getClassLoader(),
                new Class<?>[]{interfaceClass},
                new EmptyInvocationHandler()
        );
    }

    static class EmptyInvocationHandler implements java.lang.reflect.InvocationHandler {
        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            // Provide empty implementations and default values for methods
            if (method.getReturnType().equals(Void.TYPE)) {
                // For void methods, do nothing
            } else if (method.getReturnType().equals(String.class)) {
                // Return an empty string for String methods
                return "";
            } else if (method.getReturnType().equals(Integer.TYPE)) {
                // Return 0 for int methods
                return 0;
            }
            // Add more cases for other return types if needed Return null for other types
            return null;
        }
    }
}
