package com.ohaotian.venus.extension.processor;

import com.ohaotian.venus.extension.handler.ExtensionAnnotationHandle;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.Ordered;
import org.springframework.stereotype.Component;

import java.lang.reflect.Field;

/**
 * 标题：类名称:ExtensionInitProcessor
 * 说明：进行初始化的分析和存储
 * 时间：2023/8/10 5:37 PM
 * 作者 @author hegy2017
 */
@Slf4j
@Component
public class ExtensionInitProcessor implements BeanPostProcessor, Ordered {

    @Autowired
    private ExtensionAnnotationHandle handler;

    @Override
    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {

        Field[] fields = bean.getClass().getDeclaredFields();
        for (Field field : fields) {
            handler.repository(bean,field);
        }

        return bean;
    }

    @Override
    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    @Override
    public int getOrder() {
        return 1;
    }
}
