package com.ohaotian.venus.extension.processor;

import com.ohaotian.venus.extension.exception.FieldsNotFoundException;
import com.ohaotian.venus.extension.handler.ExtensionAnnotationHandle;
import lombok.extern.slf4j.Slf4j;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.Ordered;
import org.springframework.stereotype.Component;

import java.lang.reflect.Field;

/**
 * 标题：类名称:ExtensionProcessor
 * 说明：处理扩展的注入
 * 时间：2023/8/10 11:14 AM
 * 作者 @author hegy2017
 */
@Slf4j
@Component
public class ExtensionWriedProcessor implements BeanPostProcessor, Ordered {

    @Autowired
    private ExtensionAnnotationHandle handler;

    @Override
    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return this.invokeBean(bean);
    }

    @Override
    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    /**
     * 重新解析Bean依赖
     */
    private Object invokeBean(Object bean) {

        Field[] fields = getDeclaredFields(bean);
        for (Field field : fields) {
            if (handler.hasExist(field)) {
                bean = handler.invoke(bean, field);
            }
        }

        return bean;
    }

    /**
     * 获取Bean的所有字段
     *
     * @param bean
     * @return
     */
    private Field[] getDeclaredFields(Object bean) {
        if (AopUtils.isAopProxy(bean)) {
            try {
                return bean.getClass().getSuperclass().getDeclaredFields();
            } catch (SecurityException e) {
                e.printStackTrace();
                throw new FieldsNotFoundException("Extension get bean '" + bean.getClass().getSuperclass().getSimpleName() + "' declared fields not found ");
            }
        }
        return bean.getClass().getDeclaredFields();
    }

    @Override
    public int getOrder() {
        return 3;
    }
}
