package com.ohaotian.venus.extension.scanner;

import com.ohaotian.venus.extension.IExtensionPoint;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeansException;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;

/**
 * 标题：类名称:ExtensionBeanScanner
 * 说明：这个类用于扩展层，仅供参考，扩展应用不加入本插件
 * 时间：2023/8/10 2:58 PM
 * 作者 @author hegy2017
 */
@Slf4j
@Component
@ConditionalOnProperty(name = "ext.config.ext-service", havingValue = "true")
public class ExtensionBeanScanner implements ApplicationContextAware {

    private ApplicationContext context;

    @PostConstruct
    public void init() {
        String[] beanNames = context.getBeanDefinitionNames();
        for (String beanName : beanNames) {
            Object bean = context.getBean(beanName);
            StringBuilder sb = new StringBuilder();
            if (bean instanceof IExtensionPoint) {
                log.debug("开始扫描扩展服务里面，实现了IExtensionPoint的所有bean，用于产品服务判定是否有扩展.");
                sb.append(bean.getClass().getSimpleName());
                sb.append(",");
            }
            log.info("所有的扩展类名称为：" + sb);
        }
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = applicationContext;
    }
}
