/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.venus.extension.processor;

import com.ohaotian.venus.extension.exception.FieldsNotFoundException;
import com.ohaotian.venus.extension.handler.ExtensionAnnotationHandle;
import java.lang.reflect.Field;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.Ordered;
import org.springframework.stereotype.Component;

@Component
public class ExtensionWriedProcessor
implements BeanPostProcessor,
Ordered {
    private static final Logger log = LoggerFactory.getLogger(ExtensionWriedProcessor.class);
    @Autowired
    private ExtensionAnnotationHandle handler;

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return this.invokeBean(bean);
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    private Object invokeBean(Object bean) {
        Field[] fields;
        for (Field field : fields = this.getDeclaredFields(bean)) {
            if (!this.handler.hasExist(field)) continue;
            bean = this.handler.invoke(bean, field);
        }
        return bean;
    }

    private Field[] getDeclaredFields(Object bean) {
        if (AopUtils.isAopProxy((Object)bean)) {
            try {
                return bean.getClass().getSuperclass().getDeclaredFields();
            }
            catch (SecurityException e) {
                e.printStackTrace();
                throw new FieldsNotFoundException("Extension get bean '" + bean.getClass().getSuperclass().getSimpleName() + "' declared fields not found ");
            }
        }
        return bean.getClass().getDeclaredFields();
    }

    public int getOrder() {
        return 3;
    }
}

