package com.tydic.datasync.event.advice;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ReflectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.datasync.event.bo.ChannelEvent;
import com.tydic.datasync.event.bo.DataSyncConstant;
import com.tydic.dyc.base.bo.BaseRspBo;
import com.tydic.dyc.base.constants.MdcConstants;
import com.tydic.dyc.base.events.Event;
import lombok.extern.slf4j.Slf4j;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import redis.clients.jedis.Jedis;

import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;

/**
 * 标题：类名称:DataSyncAppEventByPointCutAdvice
 * 说明：描述一下类的作用TODO
 * 时间：2022/3/7 9:58 AM
 * 作者 @author hegy2017
 */
@Slf4j
public class DataSyncAppEventByPointCutAdvice implements MethodInterceptor {

    /**
     * 缓存对象
     */
    private CacheClient cacheClient;


    public DataSyncAppEventByPointCutAdvice(CacheClient cacheClient) {
        this.cacheClient = cacheClient;
    }

    @Override
    public Object invoke(MethodInvocation invocation) throws Throwable {

        String traceId = "";
        /**
         * 给参数中设置流水号，
         */
        Object[] args = invocation.getArguments();
        if (null != args && args.length > 0) {
            for (Object arg : args) {
                // 判断Bean是否包含值为null链路ID字段
                if (fieldIsNull(arg, MdcConstants.REQUEST_ID)) {
                    Object object = BeanUtil.getFieldValue(arg, MdcConstants.REQUEST_ID);
                    if (Objects.isNull(object)) {
                        traceId = UUID.randomUUID().toString().replace("-", "");
                        log.info("数据同步组件，应用层生成traceId:" + traceId);
                        BeanUtil.setFieldValue(arg, MdcConstants.REQUEST_ID, traceId);
                        break;
                    }
                }
            }
        }


        log.info("数据同步组件，应用层traceId为:" + traceId);

        /**
         * 执行切面
         */
        BaseRspBo rspObj = (BaseRspBo) invocation.proceed();

        /**
         * 应用层调用，需要发送MQ消息
         */
        final String eventsList = (String) cacheClient.get(traceId);
        log.info("数据同步组件，应用层从redis获取事件执行出参:" + eventsList);
        if (eventsList != null) {
            JSONArray eventArray = JSONArray.parseArray(eventsList);
            List<Event> traceEventList = JSONArray.parseArray(eventArray.toString(), Event.class);

            try (Jedis jedis = cacheClient.getJedisPool().getResource()) {
                if (!traceEventList.isEmpty()) {
                    ChannelEvent channelEvent = new ChannelEvent();
                    channelEvent.setTraceId(traceId);
                    channelEvent.setTraceEventList(traceEventList);
                    jedis.publish(DataSyncConstant.CHANNEL_ID, JSON.toJSONString(channelEvent));
                }
            } catch (Exception e) {
                e.printStackTrace();
            }

        }
        return rspObj;
    }


    /**
     * 描述:判断对象的某字段是否为空
     *
     * @param arg       入参对象
     * @param fieldName 字段名称
     * @return boolean 为空返回true，字段不存在返回false
     * @author tgy
     * @date 2022/3/9 16:30
     */
    public static boolean fieldIsNull(Object arg, String fieldName) {
        for (Map.Entry<String, Field> en : ReflectUtil.getFieldMap(arg.getClass()).entrySet()) {
            if (fieldName.equals(en.getKey())) {
                Object fieldValue = ReflectUtil.getFieldValue(arg, en.getValue());
                if (fieldValue == null) {
                    return true;
                } else {
                    return false;
                }
            } else {
                return false;
            }
        }
        return false;
    }
}
