package com.tydic.datasync.event.config;

import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.datasync.event.advice.DataSyncAppEventByPointCutAdvice;
import com.tydic.datasync.event.advice.DataSyncDomainEventByPointCutAdvice;
import com.tydic.datasync.event.properties.DataSyncEventProperties;
import lombok.extern.slf4j.Slf4j;
import org.springframework.aop.aspectj.AspectJExpressionPointcutAdvisor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.util.StringUtils;

/**
 * 标题：类名称:DataSyncEventConfigurableAdvisorConfig
 * 说明：切面配置类
 * 时间：2022/3/2 11:24 AM
 * 作者 @author hegy2017
 */
@Slf4j
@Configuration
@ConditionalOnProperty(name = "data.sync.event.open-event", havingValue = "true")
@EnableConfigurationProperties(DataSyncEventProperties.class)
public class DataSyncEventConfigurableAdvisorConfig {

    /**
     * 切点包路径分隔符
     */
    private static final String PACKAGE_DELIMITER = ",";

    /**
     * 调用配置项
     */
    @Autowired
    private DataSyncEventProperties dataSyncEventProperties;


    @Autowired
    private CacheClient cacheClient;

    @Bean
    @Order(-1)
    public AspectJExpressionPointcutAdvisor multipleDataSourceAdvisor() {
        AspectJExpressionPointcutAdvisor advisor = new AspectJExpressionPointcutAdvisor();
        //组装切点规则
        StringBuilder expressionBuilder = null;
        if (StringUtils.hasText(dataSyncEventProperties.getPointcutPackage())) {
            if (dataSyncEventProperties.getPointcutPackage().contains(PACKAGE_DELIMITER)) {
                String[] nativeRpcPackageSplit = dataSyncEventProperties.getPointcutPackage().split(PACKAGE_DELIMITER);
                for (String nativeRpcPackageString : nativeRpcPackageSplit) {
                    if (StringUtils.hasText(nativeRpcPackageString)) {
                        if (null == expressionBuilder) {
                            expressionBuilder = new StringBuilder();
                            expressionBuilder.append("(execution(* ").append(nativeRpcPackageString).append("..*(..)))");
                        } else {
                            expressionBuilder.append(" || (execution(* ").append(nativeRpcPackageString).append("..*(..)))");
                        }
                    }
                }
            } else {
                expressionBuilder = new StringBuilder();
                expressionBuilder.append("(execution(* ").append(dataSyncEventProperties.getPointcutPackage()).append("..*(..)))");
            }
        }

        String expression = String.valueOf(expressionBuilder);
        advisor.setExpression(expression);
        log.info("数据同步切面表达式为：" + expression);
        if (dataSyncEventProperties.getUseDomain()) {
            /**
             * 领域层调用
             */
            log.info("数据同步初始化：领域层");
            advisor.setAdvice(new DataSyncDomainEventByPointCutAdvice(cacheClient));
        } else {
            /**
             * 应用层调用
             */
            log.info("数据同步初始化：应用层");
            advisor.setAdvice(new DataSyncAppEventByPointCutAdvice(cacheClient));
        }

        log.info("切面配置完成，切点规则为：{}", expression);
        return advisor;
    }
}
