package com.tydic.datasync.event.config.mq;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.ohaotian.plugin.mq.proxy.ProxySendResult;
import com.tydic.datasync.event.bo.ChannelEvent;
import com.tydic.datasync.event.properties.DataSyncEventDeadMqProperties;
import com.tydic.datasync.event.properties.DataSyncEventProperties;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

/**
 * 标题：类名称:EventMqProvider
 * 说明：描述一下类的作用TODO
 * 时间：2022/3/2 2:39 PM
 * 作者 @author hegy2017
 */
@Slf4j
@Component
public class EventMqProvider {


    @Resource(name = "eventProvider")
    private ProxyMessageProducer proxyMessageProducer;

    @Autowired
    private DataSyncEventProperties eventProperties;

    @Autowired
    private DataSyncEventDeadMqProperties deadMqProperties;


    /**
     * 发送死信消息
     *
     * @param module
     * @param channelEvent
     * @return
     */
    public ProxySendResult provideDeadMessage(String module, ChannelEvent channelEvent) {

        return provideMessage(deadMqProperties.getTopic(), module, channelEvent);

    }


    /**
     * 发送事件
     *
     * @param module
     * @param channelEvent
     * @return
     */
    public ProxySendResult provideMessage(String module, ChannelEvent channelEvent) {
        ProxySendResult sendResult;

        if (log.isDebugEnabled()) {
            log.debug("init send message is ：" + JSONObject.toJSONString(channelEvent));
        }

        try {
            sendResult = proxyMessageProducer.send(new ProxyMessage(eventProperties.getTopic(), module,
                    JSONObject.toJSONString(channelEvent)));

            if (log.isDebugEnabled()) {
                log.debug("app event send message success !");
            }
        } catch (Exception e) {
            throw new ZTBusinessException("app event  send message failed！");
        }
        return sendResult;
    }

    /**
     * 发送事件
     *
     * @param topic
     * @param module
     * @param channelEvent
     * @return
     */
    public ProxySendResult provideMessage(String topic, String module, ChannelEvent channelEvent) {
        ProxySendResult sendResult;

        if (log.isDebugEnabled()) {
            log.debug("init send message is ：" + JSONObject.toJSONString(channelEvent));
        }

        try {
            sendResult = proxyMessageProducer.send(new ProxyMessage(topic, module,
                    JSONObject.toJSONString(channelEvent)));

            if (log.isDebugEnabled()) {
                log.debug("app event send message success !");
            }
        } catch (Exception e) {
            throw new ZTBusinessException("app event  send message failed！");
        }
        return sendResult;
    }
}
