package com.tydic.datasync.event.handler;

import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.datasync.event.bo.DataSyncConstant;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import redis.clients.jedis.Jedis;

import javax.annotation.PostConstruct;

/**
 * 标题：类名称:DataSyncEventHandler
 * 说明：事件同步消息处理器
 * 时间：2022/3/3 5:56 PM
 * 作者 @author hegy2017
 */
@Component
@Slf4j
@Order(value = 1)
public class DataSyncEventHandler implements CommandLineRunner {

    @Autowired
    private CacheClient cacheClient;

    @Autowired
    private RedisEventMessagePubSub messagePubSub;

    /**
     * 订阅方法发送的流水事件
     */
    public void doSubscribe() {
        try (Jedis jedis = cacheClient.getJedisPool().getResource()) {
            jedis.subscribe(messagePubSub, DataSyncConstant.CHANNEL_ID);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void run(String... strings) throws Exception {
        log.debug("容器启动完成，开始监听redis消息队列！！！");
        doSubscribe();
    }
}
