package com.tydic.datasync.event.quartz;

import com.alibaba.fastjson.JSONArray;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.datasync.event.bo.ChannelEvent;
import com.tydic.datasync.event.bo.DataSyncConstant;
import com.tydic.datasync.event.config.mq.EventMqProvider;
import com.tydic.dyc.base.events.Event;
import lombok.extern.slf4j.Slf4j;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.quartz.QuartzJobBean;
import org.springframework.stereotype.Component;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

/**
 * 标题：类名称:DataSyncCacheEventJob
 * 说明：数据同步定时清除任务
 * 时间：2022/3/3 8:26 PM
 * 作者 @author hegy2017
 */
@Slf4j
//@Component
public class DataSyncCacheEventJob extends QuartzJobBean {

    private static Map<String, Integer> timesMap = new ConcurrentHashMap<>(16);

    @Autowired
    private CacheClient cacheClient;

    @Autowired
    private EventMqProvider eventMqProvider;

    /**
     * redis key 的长度,固定值
     */
    private final Integer KEY_LENGTH = 3;

    @Override
    protected void executeInternal(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        //定时执行
        log.info("Event Data Sync Job. Start！");
        //这里去获取所有的key开头的缓存
        final Set<String> keys = cacheClient.getkeys(DataSyncConstant.CACHE_PREFIX + "*");
        keys.forEach(key -> {
            //是否需要进入死信队列
            Integer times = timesMap.get(key);
            if (times == null) {
                times = KEY_LENGTH;
            }
            final String[] splits = key.split(DataSyncConstant.CONNECTOR_SYMBOL);
            if (!KEY_LENGTH.equals(splits.length)) {
                return;
            }
            final String eventsList = (String) cacheClient.get(key);
            JSONArray eventArray = JSONArray.parseArray(eventsList);
            ChannelEvent channelEvent = new ChannelEvent();
            channelEvent.setTraceId(key);
            channelEvent.setTraceEventList(JSONArray.parseArray(eventArray.toString(), Event.class));
            if (times > 0) {
                eventMqProvider.provideMessage(splits[1], channelEvent);
                timesMap.put(key, --times);
            } else {
                //发送到死信队列
                eventMqProvider.provideDeadMessage(splits[1], channelEvent);
            }

        });

        log.info("Event Data Sync Job. End！");
    }
}
