/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.datasync.event.advice;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ReflectUtil;
import com.alibaba.fastjson.JSONArray;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.datasync.event.bo.ChannelEvent;
import com.tydic.datasync.event.config.mq.EventMqProvider;
import com.tydic.dyc.base.bo.BaseRspBo;
import com.tydic.dyc.base.events.Event;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSyncAppEventByPointCutAdvice
implements MethodInterceptor {
    private static final Logger log = LoggerFactory.getLogger(DataSyncAppEventByPointCutAdvice.class);
    private CacheClient cacheClient;
    private EventMqProvider eventMqProvider;

    public DataSyncAppEventByPointCutAdvice(CacheClient cacheClient, EventMqProvider eventMqProvider) {
        this.cacheClient = cacheClient;
        this.eventMqProvider = eventMqProvider;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        String traceId = "";
        Object[] args = invocation.getArguments();
        if (null != args && args.length > 0) {
            for (Object arg : args) {
                Object object;
                if (!DataSyncAppEventByPointCutAdvice.fieldIsNull(arg, "traceId") || !Objects.isNull(object = BeanUtil.getFieldValue((Object)arg, (String)"traceId"))) continue;
                traceId = UUID.randomUUID().toString().replace("-", "");
                log.info("\u6570\u636e\u540c\u6b65\u7ec4\u4ef6\uff0c\u5e94\u7528\u5c42\u751f\u6210traceId:" + traceId);
                BeanUtil.setFieldValue((Object)arg, (String)"traceId", (Object)traceId);
                break;
            }
        }
        log.info("\u6570\u636e\u540c\u6b65\u7ec4\u4ef6\uff0c\u5e94\u7528\u5c42traceId\u4e3a:" + traceId);
        BaseRspBo rspObj = (BaseRspBo)invocation.proceed();
        String eventsList = (String)this.cacheClient.get(traceId);
        log.info("\u6570\u636e\u540c\u6b65\u7ec4\u4ef6\uff0c\u5e94\u7528\u5c42\u4eceredis\u83b7\u53d6\u4e8b\u4ef6\u6267\u884c\u51fa\u53c2(traceId=" + traceId + "):" + eventsList);
        if (eventsList != null) {
            JSONArray eventArray = JSONArray.parseArray((String)eventsList);
            List traceEventList = JSONArray.parseArray((String)eventArray.toString(), Event.class);
            Map<String, List<Event>> eventGroupMap = traceEventList.stream().collect(Collectors.groupingBy(Event::getModel));
            for (Map.Entry<String, List<Event>> entry : eventGroupMap.entrySet()) {
                StringBuilder sb = new StringBuilder();
                sb.append("mqEvent");
                sb.append("-");
                sb.append(entry.getKey());
                sb.append("-");
                sb.append(traceId);
                ChannelEvent mqMessage = new ChannelEvent();
                mqMessage.setTraceId(sb.toString());
                mqMessage.setTraceEventList(entry.getValue());
                this.eventMqProvider.provideMessage(entry.getKey(), mqMessage);
                log.info("\u53d1\u9001mq\u6d88\u606f,key:" + entry.getKey());
            }
        }
        return rspObj;
    }

    public static boolean fieldIsNull(Object arg, String fieldName) {
        for (Map.Entry en : ReflectUtil.getFieldMap(arg.getClass()).entrySet()) {
            Object fieldValue;
            if (!fieldName.equals(en.getKey()) || (fieldValue = ReflectUtil.getFieldValue((Object)arg, (Field)((Field)en.getValue()))) != null) continue;
            return true;
        }
        return false;
    }
}

