/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.datasync.event.config.mq;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.ohaotian.plugin.mq.proxy.ProxySendResult;
import com.tydic.datasync.event.bo.ChannelEvent;
import com.tydic.datasync.event.properties.DataSyncEventDeadMqProperties;
import com.tydic.datasync.event.properties.DataSyncEventProperties;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class EventMqProvider {
    private static final Logger log = LoggerFactory.getLogger(EventMqProvider.class);
    @Resource(name="eventProvider")
    private ProxyMessageProducer proxyMessageProducer;
    @Autowired
    private DataSyncEventProperties eventProperties;
    @Autowired
    private DataSyncEventDeadMqProperties deadMqProperties;

    public ProxySendResult provideDeadMessage(String module, ChannelEvent channelEvent) {
        return this.provideMessage(this.deadMqProperties.getTopic(), module, channelEvent);
    }

    public ProxySendResult provideMessage(String module, ChannelEvent channelEvent) {
        ProxySendResult sendResult;
        if (log.isDebugEnabled()) {
            log.debug("init send message is \uff1a" + JSONObject.toJSONString((Object)channelEvent));
        }
        try {
            sendResult = this.proxyMessageProducer.send(new ProxyMessage(this.eventProperties.getTopic(), module, JSONObject.toJSONString((Object)channelEvent)));
            if (log.isDebugEnabled()) {
                log.debug("app event send message success !");
            }
        }
        catch (Exception e) {
            log.error("\u4e8b\u4ef6\u53d1\u9001\u6d88\u606f\u5f02\u5e38,{}", (Object)e.getMessage());
            e.printStackTrace();
            throw new ZTBusinessException("app event  send message failed\uff01");
        }
        return sendResult;
    }

    public ProxySendResult provideMessage(String topic, String module, ChannelEvent channelEvent) {
        ProxySendResult sendResult;
        if (log.isDebugEnabled()) {
            log.debug("init send message is \uff1a" + JSONObject.toJSONString((Object)channelEvent));
        }
        try {
            sendResult = this.proxyMessageProducer.send(new ProxyMessage(topic, module, JSONObject.toJSONString((Object)channelEvent)));
            if (log.isDebugEnabled()) {
                log.debug("app event send message success !");
            }
        }
        catch (Exception e) {
            throw new ZTBusinessException("app event  send message failed\uff01");
        }
        return sendResult;
    }
}

