package com.tydic.datasync.event.advice;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.ReflectUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.datasync.event.bo.DataSyncConstant;
import com.tydic.datasync.event.handler.EventMsgSenderService;
import com.tydic.dyc.base.bo.BaseRspBo;
import com.tydic.dyc.base.constants.MdcConstants;
import lombok.extern.slf4j.Slf4j;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;

/**
 * 标题：类名称:DataSyncAppEventByPointCutAdvice
 * 说明：描述一下类的作用TODO
 * 时间：2022/3/7 9:58 AM
 * 作者 @author hegy2017
 */
@Slf4j
public class DataSyncAppEventByPointCutAdvice implements MethodInterceptor {

    /**
     * 缓存对象
     */
    private CacheClient cacheClient;

    /**
     * 消息队列
     */
    private EventMsgSenderService eventMsgSenderService;


    public DataSyncAppEventByPointCutAdvice(CacheClient cacheClient, EventMsgSenderService eventMsgSenderService) {
        this.cacheClient = cacheClient;
        this.eventMsgSenderService = eventMsgSenderService;
    }

    @Override
    public Object invoke(MethodInvocation invocation) throws Throwable {

        String traceId = "";
        /**
         * 给参数中设置流水号，
         */
        Object[] args = invocation.getArguments();
        Method method = invocation.getMethod();
        String className = method.getDeclaringClass().getName();
        String methodName = method.getName();
        String classPath = className + "." + methodName;
        if (log.isDebugEnabled()) {
            log.debug("数据同步组件，应用层类路径为：" + classPath);
        }

        if (null != args && args.length > 0) {
            for (Object arg : args) {
                // 判断Bean是否包含值为null链路ID字段
                if (fieldIsNull(arg, MdcConstants.REQUEST_ID)) {
                    Object object = BeanUtil.getFieldValue(arg, MdcConstants.REQUEST_ID);
                    if (Objects.isNull(object)) {

                        traceId =
                                DataSyncConstant.CACHE_PREFIX + DataSyncConstant.CONNECTOR_SYMBOL + UUID.randomUUID().toString().replace("-", "");
                        if (log.isDebugEnabled()) {
                            log.debug("数据同步组件，应用层生成traceId:" + traceId);
                        }
                        BeanUtil.setFieldValue(arg, MdcConstants.REQUEST_ID, traceId);
                        break;
                    }
                }
            }
        }
        log.info("数据同步组件，应用层类路径为：" + classPath + " || 数据同步组件，应用层traceId为:" + traceId);

        BaseRspBo rspObj = null;
        /**
         * 执行切面
         */
        if (log.isDebugEnabled()) {
            log.debug("traceId:" + traceId + " 数据同步组件，应用层入参为：" + JSON.toJSONString(args));
        }
        try {
            rspObj = (BaseRspBo) invocation.proceed();
        } catch (Exception e) {
            if (ObjectUtil.isEmpty(traceId)) {
                if (log.isDebugEnabled()) {
                    log.debug("traceId:" + traceId + " 数据同步组件，traceId为空，类路径为：" + classPath);
                }

            } else {
                final String eventsList = (String) cacheClient.get(traceId);

                log.info("数据同步组件，应用层从redis获取事件执行出参(traceId=" + traceId + "):" + eventsList);


                if (ObjectUtil.isEmpty(eventsList)) {
                    if (log.isDebugEnabled()) {
                        log.debug("traceId:" + traceId + " 数据同步组件，redis获取事件执行出参为空，类路径为：" + classPath);
                    }
                }
                eventMsgSenderService.sendMsg(traceId, eventsList);
            }
            log.error("数据同步应用层调用异常：" ,e);
            throw e;
        }

        if (log.isDebugEnabled()) {
            log.debug("traceId:" + traceId + " 数据同步组件，应用层出参为：" + JSON.toJSONString(rspObj));
        }

        if (ObjectUtil.isEmpty(traceId)) {
            if (log.isDebugEnabled()) {
                log.debug("traceId:" + traceId + " 数据同步组件，traceId为空，类路径为：" + classPath);
            }

        } else {
            /**
             * 应用层调用，需要发送MQ消息
             */
            final String eventsList = (String) cacheClient.get(traceId);
            if (log.isDebugEnabled()) {
                log.debug("数据同步组件，应用层从redis获取事件执行出参(traceId=" + traceId + "):" + eventsList);
            }

            if (ObjectUtil.isEmpty(eventsList)) {
                if (log.isDebugEnabled()) {
                    log.debug("traceId:" + traceId + " 数据同步组件，redis获取事件执行出参为空，类路径为：" + classPath);
                }
            }
            eventMsgSenderService.sendMsg(traceId, eventsList);

        }

        return rspObj;
    }

    /**
     * 描述:判断对象的某字段是否为空
     *
     * @param arg       入参对象
     * @param fieldName 字段名称
     * @return boolean 为空返回true，字段不存在返回false
     * @author tgy
     * @date 2022/3/9 16:30
     */
    public static boolean fieldIsNull(Object arg, String fieldName) {
        for (Map.Entry<String, Field> en : ReflectUtil.getFieldMap(arg.getClass()).entrySet()) {
            if (fieldName.equals(en.getKey())) {
                Object fieldValue = ReflectUtil.getFieldValue(arg, en.getValue());
                if (fieldValue == null) {
                    return true;
                }
            }
        }
        return false;
    }
}
