package com.tydic.datasync.event.properties;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;

import java.io.Serializable;

/**
 * 标题：类名称:DataSyncEventProperties
 * 说明：属性配置
 * 时间：2022/3/2 11:10 AM
 * 作者 @author hegy2017
 */
@Data
@ConfigurationProperties(prefix = "data.sync.event")
public class DataSyncEventProperties implements Serializable {

    private static final long serialVersionUID = -5221664915065955457L;
    /**
     * 同步事件开关
     */
    private Boolean openEvent = false;

    /**
     * 是否领域使用
     */
    private Boolean useDomain = true;

    /**
     * 切点包路径，多个使用英文逗号[,]分隔
     */
    private String pointcutPackage;

    /**
     * 队列主题
     */
    private String topic;

    /**
     * 队列标签
     */
    private String tag;

    /**
     * 队列ID
     */
    private String pid;

    /**
     * 队列模式
     */
    private String model;

}
