package com.tydic.datasync.event.quartz;

import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.datasync.event.bo.DataSyncConstant;
import com.tydic.datasync.event.handler.EventMsgSenderService;
import lombok.extern.slf4j.Slf4j;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.quartz.QuartzJobBean;
import org.springframework.stereotype.Component;

import java.util.Set;

/**
 * 标题：类名称:DataSyncCacheEventJob
 * 说明：数据同步定时清除任务
 * 时间：2022/3/3 8:26 PM
 * 作者 @author hegy2017
 */
@Slf4j
@Component
public class DataSyncCacheEventJob extends QuartzJobBean {


    @Autowired
    private EventMsgSenderService msgSenderService;

    @Autowired
    private CacheClient cacheClient;

    @Override
    protected void executeInternal(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        //定时执行
        log.info("Event Data Sync Job. Start！,to deal app exception but domain has finish!");
        //这里去获取所有的key开头的缓存
        final Set<String> keys = cacheClient.getkeys(DataSyncConstant.CACHE_PREFIX + DataSyncConstant.CONNECTOR_SYMBOL+"*");
        keys.forEach(key -> {
            log.info("QuartzJob deal event key!"+ key);
            //这里面的应该是出现了异常，没有正常同步的缓存数据,从新发送到mq队列
            final String eventsList = (String) cacheClient.get(key);
            msgSenderService.sendMsg(key, eventsList);

        });

        log.info("Event Data Sync Job. End！");
    }
}
