package com.tydic.datasync.event.quartz;

import org.quartz.*;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * 标题：类名称:QuartzConfiguration
 * 说明：描述一下类的作用TODO
 * 时间：2022/3/3 8:31 PM
 * 作者 @author hegy2017
 */
@Configuration
@ConditionalOnProperty(name = "data.sync.event.use-domain", havingValue = "false")
public class QuartzConfiguration {

    /**
     * 更新频率,秒
     */
    private static final int TIME = 30;


    @Bean
    public JobDetail eventDataSyncJobDetail() {
        return JobBuilder.newJob(DataSyncCacheEventJob.class).withIdentity("eventDataSyncJob")
                .storeDurably().build();
    }

    @Bean
    public Trigger eventDataSyncTrigger() {

        SimpleScheduleBuilder scheduleBuilder = SimpleScheduleBuilder.simpleSchedule()
                .withIntervalInSeconds(TIME).repeatForever();

        return TriggerBuilder.newTrigger().forJob(eventDataSyncJobDetail())
                .withIdentity("eventDataSyncTrigger").withSchedule(scheduleBuilder).build();
    }
}
