/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.datasync.event.advice;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.ReflectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.datasync.event.bo.ChannelEvent;
import com.tydic.datasync.event.config.mq.EventMqProvider;
import com.tydic.dyc.base.bo.RspBo;
import com.tydic.dyc.base.events.Event;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSyncAppEventByPointCutAdvice
implements MethodInterceptor {
    private static final Logger log = LoggerFactory.getLogger(DataSyncAppEventByPointCutAdvice.class);
    private CacheClient cacheClient;
    private EventMqProvider eventMqProvider;

    public DataSyncAppEventByPointCutAdvice(CacheClient cacheClient, EventMqProvider eventMqProvider) {
        this.cacheClient = cacheClient;
        this.eventMqProvider = eventMqProvider;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        String traceId = "";
        Object[] args = invocation.getArguments();
        Method method = invocation.getMethod();
        String className = method.getDeclaringClass().getName();
        String methodName = method.getName();
        String classPath = className + "." + methodName;
        if (null != args && args.length > 0) {
            for (Object arg : args) {
                if (DataSyncAppEventByPointCutAdvice.fieldIsNull(arg, "traceId")) {
                    Object object = BeanUtil.getFieldValue((Object)arg, (String)"traceId");
                    if (!Objects.isNull(object)) continue;
                    traceId = UUID.randomUUID().toString().replace("-", "");
                    log.info("\u6570\u636e\u540c\u6b65\u7ec4\u4ef6\uff0c\u5e94\u7528\u5c42\u751f\u6210traceId:" + traceId);
                    BeanUtil.setFieldValue((Object)arg, (String)"traceId", (Object)traceId);
                    break;
                }
                traceId = (String)ReflectUtil.getFieldValue((Object)arg, (String)"traceId");
                log.info("\u4f7f\u7528\u5916\u5c42\u4f20\u5165tracid\uff1a" + traceId);
                break;
            }
        }
        if (ObjectUtil.isEmpty((Object)traceId)) {
            traceId = "";
        }
        log.info("\u6570\u636e\u540c\u6b65\u7ec4\u4ef6\uff0c\u5e94\u7528\u5c42\u7c7b\u8def\u5f84\u4e3a\uff1a" + classPath + " || \u6570\u636e\u540c\u6b65\u7ec4\u4ef6\uff0c\u5e94\u7528\u5c42traceId\u4e3a:" + traceId);
        log.info("traceId:" + traceId + " \u6570\u636e\u540c\u6b65\u7ec4\u4ef6\uff0c\u5e94\u7528\u5c42\u5165\u53c2\u4e3a\uff1a" + JSON.toJSONString((Object)args));
        RspBo rspObj = (RspBo)invocation.proceed();
        log.info("traceId:" + traceId + " \u6570\u636e\u540c\u6b65\u7ec4\u4ef6\uff0c\u5e94\u7528\u5c42\u51fa\u53c2\u4e3a\uff1a" + JSON.toJSONString((Object)rspObj));
        if (ObjectUtil.isEmpty((Object)traceId)) {
            return rspObj;
        }
        String eventsList = (String)this.cacheClient.get(traceId);
        log.info("\u6570\u636e\u540c\u6b65\u7ec4\u4ef6\uff0c\u5e94\u7528\u5c42\u4eceredis\u83b7\u53d6\u4e8b\u4ef6\u6267\u884c\u51fa\u53c2(traceId=" + traceId + "):" + eventsList);
        if (ObjectUtil.isEmpty((Object)traceId)) {
            log.info("traceId:" + traceId + " \u6570\u636e\u540c\u6b65\u7ec4\u4ef6\uff0ctraceId\u4e3a\u7a7a\uff0c\u7c7b\u8def\u5f84\u4e3a\uff1a" + classPath);
        }
        if (ObjectUtil.isEmpty((Object)eventsList)) {
            log.info("traceId:" + traceId + " \u6570\u636e\u540c\u6b65\u7ec4\u4ef6\uff0credis\u83b7\u53d6\u4e8b\u4ef6\u6267\u884c\u51fa\u53c2\u4e3a\u7a7a\uff0c\u7c7b\u8def\u5f84\u4e3a\uff1a" + classPath);
        }
        if (eventsList != null) {
            log.info("traceId:" + traceId + " \u6570\u636e\u540c\u6b65\u7ec4\u4ef6\uff0c\u5e94\u7528\u5c42\u53d1\u9001mq\u5185\u5bb9\u4e3a\uff1a" + eventsList);
            JSONArray eventArray = JSONArray.parseArray((String)eventsList);
            List traceEventList = JSONArray.parseArray((String)eventArray.toString(), Event.class);
            Map<String, List<Event>> eventGroupMap = traceEventList.stream().collect(Collectors.groupingBy(Event::getModel));
            for (Map.Entry<String, List<Event>> entry : eventGroupMap.entrySet()) {
                StringBuilder sb = new StringBuilder();
                sb.append("mqEvent");
                sb.append("-");
                sb.append(entry.getKey());
                sb.append("-");
                sb.append(traceId);
                ChannelEvent mqMessage = new ChannelEvent();
                mqMessage.setTraceId(sb.toString());
                mqMessage.setTraceEventList(entry.getValue());
                log.info("traceId:" + traceId + " \u53d1\u9001mq\u6d88\u606f,\u5185\u5bb9\u4e3a:" + entry.getValue());
                log.info("traceId:" + traceId + " \u53d1\u9001mq\u6d88\u606f,key:" + entry.getKey());
                this.eventMqProvider.provideMessage(entry.getKey(), mqMessage);
            }
        }
        return rspObj;
    }

    public static boolean fieldIsNull(Object arg, String fieldName) {
        for (Map.Entry en : ReflectUtil.getFieldMap(arg.getClass()).entrySet()) {
            Object fieldValue;
            if (!fieldName.equals(en.getKey()) || (fieldValue = ReflectUtil.getFieldValue((Object)arg, (Field)((Field)en.getValue()))) != null) continue;
            return true;
        }
        return false;
    }
}

