/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.datasync.event.advice;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.datasync.event.bo.CacheEvent;
import com.tydic.dyc.base.bo.BaseRspBo;
import com.tydic.dyc.base.events.Event;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSyncDomainEventByPointCutAdvice
implements MethodInterceptor {
    private static final Logger log = LoggerFactory.getLogger(DataSyncDomainEventByPointCutAdvice.class);
    private CacheClient cacheClient;

    public DataSyncDomainEventByPointCutAdvice(CacheClient cacheClient) {
        this.cacheClient = cacheClient;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        List<Event> traceEventList;
        String eventsList;
        Method method = invocation.getMethod();
        String className = method.getDeclaringClass().getName();
        String methodName = method.getName();
        String classPath = className + "." + methodName;
        log.info("\u6570\u636e\u540c\u6b65\u7ec4\u4ef6\uff0c\u9886\u57df\u5c42\uff1a\u7c7b\u8def\u5f84\u4e3a\uff1a" + classPath);
        HashMap<String, Object> fieldValueMap = new HashMap<String, Object>(16);
        BaseRspBo rspObj = (BaseRspBo)invocation.proceed();
        this.dealInArgument(invocation.getArguments(), fieldValueMap);
        log.info("\u6570\u636e\u540c\u6b65\u7ec4\u4ef6\uff0c\u9886\u57df\u5c42\uff1a\u5165\u53c2\u52a0\u5165map\uff1a{}", (Object)JSON.toJSONString(fieldValueMap));
        String traceId = (String)fieldValueMap.get("traceId");
        log.info("\u6570\u636e\u540c\u6b65\u7ec4\u4ef6\uff0c\u9886\u57df\u5c42\uff1a\u83b7\u53d6traceId\u4e3a\uff1a" + traceId);
        if (ObjectUtil.isEmpty((Object)traceId)) {
            traceId = UUID.randomUUID().toString().replace("-", "");
        }
        if ((eventsList = (String)this.cacheClient.get(traceId)) != null) {
            JSONArray eventArray = JSONArray.parseArray((String)eventsList);
            traceEventList = JSONArray.parseArray((String)eventArray.toString(), Event.class);
        } else {
            traceEventList = new ArrayList();
        }
        this.dealObject(rspObj, fieldValueMap);
        List<CacheEvent> cacheEvents = this.getMethodCacheEvent(invocation);
        log.info("traceId:" + traceId + " \u9886\u57df\u5c42\u5207\u9762\u62e6\u622a\u5668: \u83b7\u53d6\u4e8b\u4ef6\u914d\u7f6e\u4e3a,{}", (Object)JSON.toJSONString(cacheEvents));
        List<Event> events = this.dealMethodEventParam(cacheEvents, fieldValueMap);
        log.info("traceId:" + traceId + " \u9886\u57df\u5c42\u5207\u9762\u62e6\u622a\u5668: \u7c7b\u8def\u5f84\u4e3a\uff1a" + classPath + ",\u4e8b\u4ef6\u4e3a,{}", (Object)JSON.toJSONString(events));
        log.info("traceId:" + traceId + " \u6570\u636e\u540c\u6b65\u7ec4\u4ef6\uff0c\u9886\u57df\u5c42\uff1a\u653e\u5165redis\u5bf9\u8c61\u4e3a\uff1a" + JSON.toJSONString(events));
        traceEventList.addAll(events);
        this.cacheClient.set(traceId, (Object)JSON.toJSONString(traceEventList), 3600);
        return rspObj;
    }

    private List<CacheEvent> getMethodCacheEvent(MethodInvocation invocation) {
        StringBuilder builder = new StringBuilder();
        Method method = invocation.getMethod();
        String className = method.getDeclaringClass().getName();
        String methodName = method.getName();
        builder.append(className).append("-").append(methodName);
        String eventJson = (String)this.cacheClient.get(builder.toString());
        if (ObjectUtil.isNotEmpty((Object)eventJson)) {
            JSONArray eventArray = JSONArray.parseArray((String)eventJson);
            return JSONArray.parseArray((String)eventArray.toString(), CacheEvent.class);
        }
        return new ArrayList<CacheEvent>();
    }

    private List<Event> dealMethodEventParam(List<CacheEvent> cacheEvents, Map<String, Object> fieldValueMap) {
        ArrayList<Event> rspEventList = new ArrayList<Event>();
        cacheEvents.forEach(cacheEvent -> {
            Event event = new Event();
            event.setCode(cacheEvent.getEventCode());
            event.setModel(cacheEvent.getModule());
            HashMap valueMap = new HashMap(16);
            List<String> params = cacheEvent.getParams();
            params.forEach(filed -> {
                Object value = fieldValueMap.get(filed);
                valueMap.put(filed, value);
            });
            event.setParamMap(valueMap);
            rspEventList.add(event);
        });
        return rspEventList;
    }

    private void dealInArgument(Object[] arguments, Map<String, Object> map) throws Throwable {
        if (arguments != null) {
            for (Object arg : arguments) {
                this.dealObject(arg, map);
            }
        }
    }

    private void dealObject(Object dealObject, Map<String, Object> fieldValueMap) throws Throwable {
        List<Field> fields = DataSyncDomainEventByPointCutAdvice.getAllField(dealObject.getClass());
        for (Field f : fields) {
            f.setAccessible(true);
            String fieldName = f.getName();
            if (null == f.get(dealObject)) continue;
            Object fieldValue = f.get(dealObject);
            fieldValueMap.put(fieldName, fieldValue);
        }
    }

    private static List<Field> getAllField(Class clazz) {
        ArrayList<Field> fields = new ArrayList<Field>();
        while (clazz != null) {
            fields.addAll(new ArrayList<Field>(Arrays.asList(clazz.getDeclaredFields())));
            clazz = clazz.getSuperclass();
        }
        return fields;
    }
}

