/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.datasync.event.advice;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.ReflectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.datasync.event.bo.ChannelEvent;
import com.tydic.datasync.event.config.mq.EventMqProvider;
import com.tydic.dyc.base.bo.BaseRspBo;
import com.tydic.dyc.base.events.Event;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Aspect
@Component
@Order(value=10)
public class DataSyncLoggerAspect {
    private static final Logger log = LoggerFactory.getLogger(DataSyncLoggerAspect.class);
    @Autowired
    private CacheClient cacheClient;
    @Autowired
    private EventMqProvider eventMqProvider;

    public DataSyncLoggerAspect() {
        log.info("DataSyncLoggerAspect\u521d\u59cb\u5316");
    }

    @Pointcut(value="(execution(* com.tydic.dyc.busicommon.*.impl..*(..))) ")
    public void pointCut() {
    }

    @Around(value="pointCut()")
    public Object around(ProceedingJoinPoint pjp) throws Throwable {
        String traceId = "";
        Object[] args = pjp.getArgs();
        MethodSignature methodSignature = (MethodSignature)pjp.getSignature();
        Method method = methodSignature.getMethod();
        String className = method.getDeclaringClass().getName();
        String methodName = method.getName();
        String classPath = className + "." + methodName;
        log.info("\u6570\u636e\u540c\u6b65\u7ec4\u4ef6\uff0c\u5e94\u7528\u5c42\u7c7b\u8def\u5f84\u4e3a\uff1a" + classPath);
        if (null != args && args.length > 0) {
            for (Object arg : args) {
                Object object;
                if (!DataSyncLoggerAspect.fieldIsNull(arg, "traceId") || !Objects.isNull(object = BeanUtil.getFieldValue((Object)arg, (String)"traceId"))) continue;
                traceId = UUID.randomUUID().toString().replace("-", "");
                log.info("\u6570\u636e\u540c\u6b65\u7ec4\u4ef6\uff0c\u5e94\u7528\u5c42\u751f\u6210traceId:" + traceId);
                BeanUtil.setFieldValue((Object)arg, (String)"traceId", (Object)traceId);
                break;
            }
        }
        log.info("\u6570\u636e\u540c\u6b65\u7ec4\u4ef6\uff0c\u5e94\u7528\u5c42traceId\u4e3a:" + traceId);
        log.info("\u6570\u636e\u540c\u6b65\u7ec4\u4ef6\uff0c\u5e94\u7528\u5c42\u5165\u53c2\u4e3a\uff1a" + JSON.toJSONString((Object)args));
        BaseRspBo rspObj = null;
        try {
            rspObj = (BaseRspBo)pjp.proceed();
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw e;
        }
        log.info("\u6570\u636e\u540c\u6b65\u7ec4\u4ef6\uff0c\u5e94\u7528\u5c42\u51fa\u53c2\u4e3a\uff1a" + JSON.toJSONString((Object)rspObj));
        String eventsList = (String)this.cacheClient.get(traceId);
        log.info("\u6570\u636e\u540c\u6b65\u7ec4\u4ef6\uff0c\u5e94\u7528\u5c42\u4eceredis\u83b7\u53d6\u4e8b\u4ef6\u6267\u884c\u51fa\u53c2(traceId=" + traceId + "):" + eventsList);
        if (ObjectUtil.isEmpty((Object)traceId)) {
            log.info("\u6570\u636e\u540c\u6b65\u7ec4\u4ef6\uff0ctraceId\u4e3a\u7a7a\uff0c\u7c7b\u8def\u5f84\u4e3a\uff1a" + classPath);
        }
        if (ObjectUtil.isEmpty((Object)eventsList)) {
            log.info("\u6570\u636e\u540c\u6b65\u7ec4\u4ef6\uff0credis\u83b7\u53d6\u4e8b\u4ef6\u6267\u884c\u51fa\u53c2\u4e3a\u7a7a\uff0c\u7c7b\u8def\u5f84\u4e3a\uff1a" + classPath);
        }
        if (eventsList != null) {
            log.info("\u6570\u636e\u540c\u6b65\u7ec4\u4ef6\uff0c\u5e94\u7528\u5c42\u53d1\u9001mq\u5185\u5bb9\u4e3a\uff1a" + eventsList);
            JSONArray eventArray = JSONArray.parseArray((String)eventsList);
            List traceEventList = JSONArray.parseArray((String)eventArray.toString(), Event.class);
            Map<String, List<Event>> eventGroupMap = traceEventList.stream().collect(Collectors.groupingBy(Event::getModel));
            for (Map.Entry<String, List<Event>> entry : eventGroupMap.entrySet()) {
                StringBuilder sb = new StringBuilder();
                sb.append("mqEvent");
                sb.append("-");
                sb.append(entry.getKey());
                sb.append("-");
                sb.append(traceId);
                ChannelEvent mqMessage = new ChannelEvent();
                mqMessage.setTraceId(sb.toString());
                mqMessage.setTraceEventList(entry.getValue());
                log.info("\u53d1\u9001mq\u6d88\u606f,\u5185\u5bb9\u4e3a:" + entry.getValue());
                log.info("\u53d1\u9001mq\u6d88\u606f,key:" + entry.getKey());
                this.eventMqProvider.provideMessage(entry.getKey(), mqMessage);
            }
        }
        return rspObj;
    }

    public static boolean fieldIsNull(Object arg, String fieldName) {
        for (Map.Entry en : ReflectUtil.getFieldMap(arg.getClass()).entrySet()) {
            Object fieldValue;
            if (!fieldName.equals(en.getKey()) || (fieldValue = ReflectUtil.getFieldValue((Object)arg, (Field)((Field)en.getValue()))) != null) continue;
            return true;
        }
        return false;
    }
}

