/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.datasync.event.quartz;

import com.alibaba.fastjson.JSONArray;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.datasync.event.bo.ChannelEvent;
import com.tydic.datasync.event.config.mq.EventMqProvider;
import com.tydic.dyc.base.events.Event;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.quartz.QuartzJobBean;

public class DataSyncCacheEventJob
extends QuartzJobBean {
    private static final Logger log = LoggerFactory.getLogger(DataSyncCacheEventJob.class);
    private static Map<String, Integer> timesMap = new ConcurrentHashMap<String, Integer>(16);
    @Autowired
    private CacheClient cacheClient;
    @Autowired
    private EventMqProvider eventMqProvider;
    private final Integer KEY_LENGTH = 3;

    protected void executeInternal(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        log.info("Event Data Sync Job. Start\uff01");
        Set keys = this.cacheClient.getkeys("mqEvent*");
        keys.forEach(key -> {
            String[] splits;
            Integer times = timesMap.get(key);
            if (times == null) {
                times = this.KEY_LENGTH;
            }
            if (!this.KEY_LENGTH.equals((splits = key.split("-")).length)) {
                return;
            }
            String eventsList = (String)this.cacheClient.get(key);
            JSONArray eventArray = JSONArray.parseArray((String)eventsList);
            ChannelEvent channelEvent = new ChannelEvent();
            channelEvent.setTraceId((String)key);
            channelEvent.setTraceEventList(JSONArray.parseArray((String)eventArray.toString(), Event.class));
            if (times > 0) {
                this.eventMqProvider.provideMessage(splits[1], channelEvent);
                times = times - 1;
                timesMap.put((String)key, times);
            } else {
                this.eventMqProvider.provideDeadMessage(splits[1], channelEvent);
            }
        });
        log.info("Event Data Sync Job. End\uff01");
    }
}

