/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.datasync.event.handler;

import com.alibaba.fastjson.JSONArray;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.datasync.event.bo.ChannelEvent;
import com.tydic.datasync.event.config.mq.EventMqProvider;
import com.tydic.dyc.base.events.Event;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class EventMsgSenderService {
    private static final Logger log = LoggerFactory.getLogger(EventMsgSenderService.class);
    @Autowired
    private CacheClient cacheClient;
    @Autowired
    private EventMqProvider eventMqProvider;

    public void sendMsg(String traceId, String eventsMsg) {
        if (StringUtils.isEmpty((String)eventsMsg)) {
            return;
        }
        log.info("traceId:" + traceId + " \u6570\u636e\u540c\u6b65\u7ec4\u4ef6\uff0c\u5e94\u7528\u5c42\u53d1\u9001mq\u5185\u5bb9\u4e3a\uff1a" + eventsMsg);
        JSONArray eventArray = JSONArray.parseArray((String)eventsMsg);
        List traceEventList = JSONArray.parseArray((String)eventArray.toString(), Event.class);
        Map<String, List<Event>> eventGroupMap = traceEventList.stream().collect(Collectors.groupingBy(Event::getModel));
        for (Map.Entry<String, List<Event>> entry : eventGroupMap.entrySet()) {
            StringBuilder sb = new StringBuilder();
            sb.append("mqEvent");
            sb.append("-");
            sb.append(entry.getKey());
            sb.append("-");
            sb.append(traceId);
            ChannelEvent mqMessage = new ChannelEvent();
            mqMessage.setTraceId(sb.toString());
            mqMessage.setTraceEventList(entry.getValue());
            log.info("traceId:" + traceId + " \u53d1\u9001mq\u6d88\u606f,\u5185\u5bb9\u4e3a:" + entry.getValue());
            this.eventMqProvider.provideMessage(entry.getKey(), mqMessage);
            log.info("traceId:" + traceId + " \u53d1\u9001mq\u6d88\u606f,key:" + entry.getKey());
        }
        this.cacheClient.delete(traceId);
        log.info("traceId:" + traceId + " \u53d1\u9001mq\u6d88\u606f,\u5df2\u5b8c\u6210\u6e05\u695a\uff01");
    }
}

