/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.datasync.event.quartz;

import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.datasync.event.handler.EventMsgSenderService;
import java.util.Set;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.quartz.QuartzJobBean;
import org.springframework.stereotype.Component;

@Component
public class DataSyncCacheEventJob
extends QuartzJobBean {
    private static final Logger log = LoggerFactory.getLogger(DataSyncCacheEventJob.class);
    @Autowired
    private EventMsgSenderService msgSenderService;
    @Autowired
    private CacheClient cacheClient;

    protected void executeInternal(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        log.info("Event Data Sync Job. Start\uff01,to deal app exception but domain has finish!");
        Set keys = this.cacheClient.getkeys("mqEvent-*");
        keys.forEach(key -> {
            log.info("QuartzJob deal event key!" + key);
            String eventsList = (String)this.cacheClient.get(key);
            this.msgSenderService.sendMsg((String)key, eventsList);
        });
        log.info("Event Data Sync Job. End\uff01");
    }
}

