/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.datasync.event.quartz;

import com.tydic.datasync.event.quartz.DataSyncCacheEventJob;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.ScheduleBuilder;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(name={"data.sync.event.use-domain"}, havingValue="false")
public class QuartzConfiguration {
    private static final int TIME = 30;

    @Bean
    public JobDetail eventDataSyncJobDetail() {
        return JobBuilder.newJob(DataSyncCacheEventJob.class).withIdentity("eventDataSyncJob").storeDurably().build();
    }

    @Bean
    public Trigger eventDataSyncTrigger() {
        SimpleScheduleBuilder scheduleBuilder = SimpleScheduleBuilder.simpleSchedule().withIntervalInSeconds(30).repeatForever();
        return TriggerBuilder.newTrigger().forJob(this.eventDataSyncJobDetail()).withIdentity("eventDataSyncTrigger").withSchedule((ScheduleBuilder)scheduleBuilder).build();
    }
}

